<?php
// add_mixing_pack.php
include 'includes/db.php';
include 'includes/header.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $title = $_POST['title'];
  $price = $_POST['price'];

  $stmt = $conn->prepare("INSERT INTO mixing_packs (title, price) VALUES (?, ?)");
  $stmt->bind_param("sd", $title, $price);
  $stmt->execute();
  $pack_id = $stmt->insert_id;

  // Insert items
  foreach ($_POST['items'] as $item) {
    $name = $item['name'];
    $qty = $item['qty'];
    if (!empty($name) && !empty($qty)) {
      $conn->query("INSERT INTO mixing_pack_items (mixing_pack_id, item_name, quantity) VALUES ('$pack_id', '$name', '$qty')");
    }
  }

  echo "<script>alert('Mixing Pack Added');location.href='add_mixing_pack.php';</script>";
}
?>

<div class="container mt-5">
  <h2>Add Mixing Pack</h2>
  <form method="POST">
    <div class="mb-3">
      <label>Pack Title</label>
      <input type="text" name="title" class="form-control" required>
    </div>
    <div class="mb-3">
      <label>Price</label>
      <input type="number" name="price" class="form-control" step="0.01" required>
    </div>
    <h5>Items</h5>
    <div id="items-wrapper">
      <div class="row mb-2">
        <div class="col">
          <input type="text" name="items[0][name]" class="form-control" placeholder="Item Name">
        </div>
        <div class="col">
          <input type="text" name="items[0][qty]" class="form-control" placeholder="Qty">
        </div>
      </div>
    </div>
    <button type="button" class="btn btn-secondary mb-3" onclick="addItem()">+ Add More</button>
    <br>
    <button class="btn btn-primary">Save Pack</button>
  </form>
</div>

<script>
let itemIndex = 1;
function addItem() {
  const wrapper = document.getElementById('items-wrapper');
  const row = document.createElement('div');
  row.className = 'row mb-2';
  row.innerHTML = `
    <div class="col">
      <input type="text" name="items[${itemIndex}][name]" class="form-control" placeholder="Item Name">
    </div>
    <div class="col">
      <input type="text" name="items[${itemIndex}][qty]" class="form-control" placeholder="Qty">
    </div>`;
  wrapper.appendChild(row);
  itemIndex++;
}
</script>
<?php include 'includes/footer.php'; ?>
