<?php
session_start();

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    // Fetch id, email, password, and region
$sql = "SELECT id, email, password, region, name FROM users WHERE email = ?";
$stmt = $conn->prepare($sql);
    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();

        if (password_verify($password, $user['password'])) {
            // Store user info in session
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['email'] = $user['email'];
            $_SESSION['user_region'] = $user['region']; // 👈 Save region here
           $_SESSION['name'] = $user['name'];  // Add this line to store the name

            // Redirect to home page
            header("Location: ../home.php");
            exit();
        } else {
            $error = "Invalid email or password.";
        }
    } else {
        $error = "Invalid email or password.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Savithri Digital Print Press | Login</title>

<!-- Bootstrap 5 -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
  body {
    font-family: 'Poppins', sans-serif;
    background: #f7f8fa;
    margin: 0;
  }

/* Header */
.header {
  background: rgba(255, 255, 255, 0.98);
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
  position: fixed;
  width: 100%;
  z-index: 1000;
  padding: 12px 6%;
  display: flex;
  justify-content: space-between;
  align-items: center;
  top: 0;
  left: 0;
}

/* LOGO + TAGLINE vertically aligned */
.logo-container {
  display: flex;
  flex-direction: column;
  align-items: flex-start;
}

.logo {
  height: 60px;
  width: auto;
  margin-bottom: 5px;
  transition: transform 0.3s ease;
}

.logo:hover {
  transform: scale(1.05);
}

.tagline {
  font-size: 14px;
  font-weight: 600;
  color: #2F2F4F;
  font-style: italic;
  letter-spacing: 0.6px;
  margin: 0;
}

/* NAV BUTTONS */
.nav-buttons {
  display: flex;
  align-items: center;
  gap: 15px;
}

.btn {
  padding: 8px 22px;
  border-radius: 25px;
  font-weight: 600;
  text-decoration: none;
  transition: all 0.3s ease;
  display: inline-flex;
  align-items: center;
  justify-content: center;
}

/* LOGIN BUTTON */
.btn-login {
  background: #fff;
  border: 2px solid #2f2a85;
  color: #2f2a85;
}

.btn-login:hover {
  background: #2f2a85;
  color: white;
}

/* REGISTER BUTTON */
.btn-register {
  background: #2f2a85;
  color: white;
}

.btn-register:hover {
  background: #221c6a;
}

/* ---------- MOBILE VIEW ---------- */
@media (max-width: 768px) {
  .header {
    flex-direction: row;
    align-items: flex-start;
    justify-content: space-between;
    padding: 10px 20px;
  }

  .logo-container {
    align-items: flex-start;
  }

  .nav-buttons {
    flex-direction: column;
    gap: 8px;
  }

  .logo {
    height: 50px;
  }

  .tagline {
    font-size: 13px;
  }

  .btn {
    padding: 6px 16px;
    font-size: 13px;
  }
}


  /* Login Card */
  .login-container {
    min-height: 80vh;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 30px 15px;
  }
  .login-form {
    background: #fff;
    border-radius: 15px;
    padding: 40px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    width: 100%;
    max-width: 420px;
        margin-top: 87px;
  }
  .login-form h2 {
    color: #2f2a85;
    text-align: center;
    font-weight: 700;
    margin-bottom: 25px;
  }
  .login-form .form-control {
    border-radius: 8px;
    padding: 12px;
  }
  .login-form .btn-primary {
    background-color: #2f2a85;
    border: none;
    border-radius: 8px;
    font-weight: 600;
    padding: 12px;
  }
  .login-form .btn-primary:hover {
    background-color: #251f6d;
  }
  .login-form p {
    text-align: center;
    margin-top: 15px;
    font-size: 14px;
  }
  .error-message {
    color: #d32f2f;
    background: #ffebee;
    padding: 10px;
    border-radius: 6px;
    margin-bottom: 15px;
    text-align: center;
  }

</style>
</head>
<body>

<!-- Header -->
<header class="header">
  <div class="logo-container">
    <img src="https://test.kalpavrukshaits.com/savithridigital/images/logo.jpeg" 
         alt="Savithri Digital Logo" class="logo">
    <p class="tagline">We Exceed Your Expectations</p>
  </div>

  <div class="nav-buttons">
    <a href="https://test.kalpavrukshaits.com/savithridigital/admin/signin.php" class="btn btn-login">
      <i class="bi bi-box-arrow-in-right"></i> Login
    </a>
    <a href="https://test.kalpavrukshaits.com/savithridigital/register.php" class="btn btn-register">
      <i class="bi bi-person-plus"></i> Register
    </a>
  </div>
</header>




<!-- Login Form -->
<section class="login-container">
  <div class="login-form">
    <h2>User Login</h2>
    <?php if ($error) { echo "<div class='error-message'>$error</div>"; } ?>

    <form method="POST">
      <div class="mb-3">
        <label class="form-label fw-semibold">Email</label>
        <input type="email" name="email" class="form-control" placeholder="Enter your email" required>
      </div>

      <div class="mb-4">
        <label class="form-label fw-semibold">Password</label>
        <input type="password" name="password" class="form-control" placeholder="Enter your password" required>
      </div>

      <button type="submit" class="btn btn-primary w-100">Login</button>

      <p class="mt-3 text-muted">Don't have an account?
        <a href="register.php" style="color:#2f2a85; text-decoration:none; font-weight:600;">Sign Up</a>
      </p>
    </form>
  </div>
</section>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
