<?php
session_start();
header('Content-Type: application/json');

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

if ($conn->connect_error) {
    die(json_encode(['error' => 'Database connection failed']));
}

// Get cart items for the current user
$user_id = $_SESSION['user_id'] ?? 0;
$cartItems = [];

if ($user_id) {
    $query = "SELECT c.*, 
                     COALESCE(p.name, pp.name) as name,
                     pkg.name as package_name,
                     CASE 
                         WHEN c.product_type = 'print' THEN COALESCE(pp.price, 0)
                         WHEN c.product_type = 'regular' THEN COALESCE(p.mrp, 0)
                         ELSE 0 
                     END as price
              FROM cart c
              LEFT JOIN products p ON (c.product_id = p.id AND c.product_type = 'regular')
              LEFT JOIN print_products pp ON (c.product_id = pp.id AND c.product_type = 'print')
              LEFT JOIN packages pkg ON p.package_id = pkg.id
              WHERE c.user_id = ?";
    
    $stmt = $conn->prepare($query);
    if ($stmt) {
        $stmt->bind_param('i', $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $cartItems = $result->fetch_all(MYSQLI_ASSOC);
    }
}

echo json_encode($cartItems);
$conn->close();
?>