<?php
session_start();
include 'header.php';

// DB connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

// Get logged-in user email from session
if (!isset($_SESSION['email'])) {
    die("You must log in first.");
}

$user_email = $_SESSION['email'];

// Fetch user ID and region
$user_query = $conn->prepare("SELECT id, region FROM users WHERE email = ?");
$user_query->bind_param("s", $user_email);
$user_query->execute();
$user_result = $user_query->get_result();
if ($user_result->num_rows === 0) {
    die("User not found.");
}
$user_data = $user_result->fetch_assoc();
$user_region = strtolower(trim($user_data['region'])); // Normalize case
$user_id = $user_data['id'];

// Get pad type ID from URL
$pad_type_id = $_GET['pad_type_id'] ?? null;
if (!$pad_type_id || !is_numeric($pad_type_id)) die("Invalid or missing pad type.");

// Fetch pad type details
$pad_type_stmt = $conn->prepare("SELECT id, name, image FROM pad_types WHERE id = ?");
$pad_type_stmt->bind_param("i", $pad_type_id);
$pad_type_stmt->execute();
$pad_type_result = $pad_type_stmt->get_result();
$pad_type = $pad_type_result->fetch_assoc();

if (!$pad_type) {
    die("Pad type not found.");
}

// Determine price column based on region
$price_column = ($user_region === "region 2") ? "price_region" : "price";

// Fetch features and prices with feature ID
$sql = "SELECT pf.id as feature_id, pf.name AS feature, 
               pp.$price_column AS price
        FROM pad_prices pp
        JOIN pad_features pf ON pf.id = pp.feature_id
        WHERE pp.pad_type_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $pad_type_id);
$stmt->execute();
$results = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
  <title><?= htmlspecialchars($pad_type['name']) ?> Prices</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background: #f8f9fa;
      font-family: Arial, sans-serif;
    }
    .feature-card {
      background: white;
      border-radius: 15px;
      padding: 15px;
      margin-bottom: 20px;
      box-shadow: 0 3px 10px rgba(0,0,0,0.1);
      display: flex;
      align-items: center;
      transition: transform 0.2s, box-shadow 0.2s;
    }
    .feature-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    .pad-icon {
      height: 60px;
      width: 60px;
      object-fit: contain;
      margin-right: 15px;
      border-radius: 10px;
    }
    .cart-btn {
      background-color: #2c3169;
      border: none;
      padding: 8px 15px;
      margin-left: 15px;
      color: white;
      border-radius: 5px;
      font-size: 14px;
      cursor: pointer;
      transition: all 0.3s;
      white-space: nowrap;
    }
    .cart-btn:hover {
      background-color: #1a1f4f;
    }
    .cart-btn:disabled {
      background-color: #6c757d;
      cursor: not-allowed;
    }
    .price {
      color: #28a745;
      font-weight: 700;
      font-size: 1.1rem;
    }
    .loading-spinner {
      display: inline-block;
      width: 1rem;
      height: 1rem;
      border: 2px solid rgba(255, 255, 255, 0.3);
      border-radius: 50%;
      border-top-color: #fff;
      animation: spin 1s ease-in-out infinite;
      margin-right: 5px;
      vertical-align: middle;
    }
    @keyframes spin {
      to { transform: rotate(360deg); }
    }
    .toast-container {
      position: fixed;
      bottom: 20px;
      right: 20px;
      z-index: 1100;
    }
    .feature-details {
      flex-grow: 1;
    }
    .action-buttons {
      display: flex;
      align-items: center;
      gap: 10px;
      flex-wrap: wrap;
      justify-content: flex-end;
    }
    .quantity-control {
      display: flex;
      align-items: center;
      border: 1px solid #dee2e6;
      border-radius: 5px;
      overflow: hidden;
      background: #fff;
    }
    .quantity-btn {
      background: #f8f9fa;
      border: none;
      width: 30px;
      height: 34px;
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      transition: background 0.2s;
    }
    .quantity-btn:hover {
      background: #e9ecef;
    }
    .quantity-input {
      width: 45px;
      text-align: center;
      border: none;
      border-left: 1px solid #dee2e6;
      border-right: 1px solid #dee2e6;
      height: 34px;
      -moz-appearance: textfield;
      font-weight: 500;
    }
    .quantity-input:focus {
      outline: none;
      box-shadow: 0 0 0 0.2rem rgba(44, 49, 105, 0.25);
    }
    .quantity-input::-webkit-outer-spin-button,
    .quantity-input::-webkit-inner-spin-button {
      -webkit-appearance: none;
      margin: 0;
    }
    .pad-type-header {
      display: flex;
      align-items: center;
      margin-bottom: 20px;
      padding-bottom: 10px;
      border-bottom: 1px solid #dee2e6;
    }
    .pad-type-image {
      width: 60px;
      height: 60px;
      object-fit: contain;
      margin-right: 15px;
      border-radius: 8px;
      background: #f8f9fa;
      padding: 5px;
    }
    .pad-type-title {
      margin: 0;
      color: #2c3169;
    }
    @media (max-width: 768px) {
      .feature-card {
        flex-direction: column;
        text-align: center;
      }
      .pad-icon {
        margin: 0 0 15px 0;
      }
      .action-buttons {
        margin-top: 15px;
        width: 100%;
        justify-content: center;
      }
    }
  </style>
</head>
<body>
<div class="container py-4">
  <div class="pad-type-header">
    <?php if (!empty($pad_type['image'])): ?>
      <img src="uploads/<?= htmlspecialchars($pad_type['image']) ?>" 
           alt="<?= htmlspecialchars($pad_type['name']) ?>" 
           class="pad-type-image">
    <?php endif; ?>
    <h1 class="pad-type-title"><?= htmlspecialchars($pad_type['name']) ?></h1>
  </div>

  <div class="row">
    <div class="col-12">
      <div class="alert alert-info">
        <i class="bi bi-info-circle-fill me-2"></i>
        All items will be grouped under "<?= htmlspecialchars($pad_type['name']) ?>" in your cart
      </div>
    </div>
  </div>

  <div class="row">
    <?php while ($row = $results->fetch_assoc()): ?>
      <div class="col-md-6 col-lg-4 mb-4">
        <div class="feature-card h-100">
          <div class="feature-details">
            <h5 class="mb-2"><?= htmlspecialchars($row['feature']) ?></h5>
            <p class="price mb-2">₹<?= number_format($row['price'], 2) ?></p>
            <div class="action-buttons">
              <div class="quantity-control">
                <button type="button" class="quantity-btn decrease" onclick="updateQuantity(this, -1)">-</button>
                <input type="number" class="quantity-input" value="1" min="1" 
                       data-feature-id="<?= $row['feature_id'] ?>">
                <button type="button" class="quantity-btn increase" onclick="updateQuantity(this, 1)">+</button>
              </div>
              <button class="cart-btn" 
                      data-feature-id="<?= $row['feature_id'] ?>"
                      data-feature-name="<?= htmlspecialchars($row['feature']) ?>"
                      data-price="<?= $row['price'] ?>">
                <i class="bi bi-cart-plus"></i> Add to Cart
              </button>
            </div>
          </div>
        </div>
      </div>
    <?php endwhile; ?>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Store pad type information
const padTypeInfo = {
    id: <?= $pad_type['id'] ?>,
    name: "<?= addslashes($pad_type['name']) ?>"
};

// Add to cart function for pad products
async function addToCart(button) {
    const featureId = button.dataset.featureId;
    const quantity = parseInt(button.closest('.action-buttons').querySelector('.quantity-input').value) || 1;
    const featureName = button.dataset.featureName;
    const price = parseFloat(button.dataset.price) || 0;
    
    const originalHTML = button.innerHTML;
    button.disabled = true;
    button.innerHTML = '<span class="loading-spinner"></span> Adding...';

    try {
        const response = await fetch('add_pad_to_cart.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                product_id: featureId,
                quantity: quantity,
                name: featureName,
                price: price,
                pad_type_id: padTypeInfo.id,
                pad_type_name: padTypeInfo.name
            })
        });

        const result = await response.json();
        console.log('Server response:', result);

        if (result.success) {
            // Update cart count
            const cartCount = document.querySelector('.cart-count');
            if (cartCount) {
                cartCount.textContent = result.cart_count || '0';
                cartCount.classList.add('active');
            }
            
            // Show success message
            showToast('Added to cart!', 'success');
            
            // Update button state
            button.innerHTML = '<i class="bi bi-check-lg"></i> Added';
            setTimeout(() => {
                button.innerHTML = originalHTML;
                button.disabled = false;
            }, 2000);
        } else {
            throw new Error(result.error || 'Failed to add to cart');
        }
    } catch (error) {
        console.error('Error:', error);
        showToast(error.message, 'danger');
        button.disabled = false;
        button.innerHTML = originalHTML;
    }
}

// Quantity controls
function updateQuantity(button, change) {
    const input = button.closest('.quantity-control').querySelector('.quantity-input');
    let newValue = parseInt(input.value) + change;
    if (newValue < 1) newValue = 1;
    input.value = newValue;
}

// Toast notification
function showToast(message, type = 'info') {
    // Create container if it doesn't exist
    let container = document.querySelector('.toast-container');
    if (!container) {
        container = document.createElement('div');
        container.className = 'toast-container';
        document.body.appendChild(container);
    }

    // Create toast element
    const toast = document.createElement('div');
    toast.className = `toast show align-items-center text-white bg-${type} border-0 mb-2`;
    toast.role = 'alert';
    toast.setAttribute('aria-live', 'assertive');
    toast.setAttribute('aria-atomic', 'true');
    
    toast.innerHTML = `
        <div class="d-flex">
            <div class="toast-body">
                ${message}
            </div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    `;
    
    container.appendChild(toast);
    
    // Auto-remove after 3 seconds
    setTimeout(() => {
        const bsToast = new bootstrap.Toast(toast);
        bsToast.hide();
        toast.addEventListener('hidden.bs.toast', () => {
            toast.remove();
        });
    }, 3000);
}

// Event listeners
document.addEventListener('DOMContentLoaded', function() {
    // Add to cart button click
    document.addEventListener('click', function(e) {
        if (e.target.closest('.cart-btn')) {
            e.preventDefault();
            addToCart(e.target.closest('.cart-btn'));
        }
    });

    // Quantity input validation
    document.addEventListener('input', function(e) {
        if (e.target.classList.contains('quantity-input')) {
            if (e.target.value < 1) {
                e.target.value = 1;
            }
        }
    });

    // Initialize tooltips
    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>

</body>
</html>