<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'error' => 'Please login to update cart']);
    exit;
}

$cart_id = isset($_POST['cart_id']) ? (int)$_POST['cart_id'] : 0;
$quantity = isset($_POST['quantity']) ? (int)$_POST['quantity'] : 1;

if ($cart_id <= 0) {
    echo json_encode(['success' => false, 'error' => 'Invalid cart item']);
    exit;
}

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

// Verify the cart item belongs to the user
$stmt = $conn->prepare("SELECT id FROM cart WHERE id = ? AND user_id = ?");
$stmt->bind_param("ii", $cart_id, $_SESSION['user_id']);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(['success' => false, 'error' => 'Cart item not found']);
    $conn->close();
    exit;
}

// Update the quantity
$update = $conn->prepare("UPDATE cart SET quantity = ?, updated_at = NOW() WHERE id = ?");
$update->bind_param("ii", $quantity, $cart_id);
$success = $update->execute();

// Get updated cart count
$count_result = $conn->query("
    SELECT COALESCE(SUM(quantity), 0) as count 
    FROM cart 
    WHERE user_id = " . $_SESSION['user_id']
);
$count = $count_result ? (int)$count_result->fetch_assoc()['count'] : 0;

$conn->close();

echo json_encode([
    'success' => $success,
    'cart_count' => $count
]);