<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Include database connection
    include 'db.php';

    $reportType = $_POST['report_type'];
    $productName = $_POST['product_name'];
    $quantity = $_POST['quantity'];
    $price = $_POST['price'];
    $totalPrice = $quantity * $price;

    if ($reportType === "purchase") {
        $pdo->prepare("INSERT INTO purchases_transactions (product_name, quantity, total_price, purchase_date) VALUES (?, ?, ?, NOW())")
            ->execute([$productName, $quantity, $totalPrice]);
    } elseif ($reportType === "sales") {
        $pdo->prepare("INSERT INTO sales_transactions (product_name, quantity, total_price, sale_date) VALUES (?, ?, ?, NOW())")
            ->execute([$productName, $quantity, $totalPrice]);
    }
    echo "<script>alert('Report added successfully!');window.location.href='index.php';</script>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add New Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f5f5f5;
            padding: 20px;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        h1 {
            text-align: center;
            color: #007bff;
        }

        form {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }

        form input, form select, form button {
            font-size: 16px;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }

        form button {
            background: #007bff;
            color: white;
            border: none;
            cursor: pointer;
            font-weight: bold;
        }

        form button:hover {
            background: #0056b3;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Add New Report</h1>
        <form method="post">
            <label for="report_type">Report Type:</label>
            <select name="report_type" id="report_type" required>
                <option value="">Select Report Type</option>
                <option value="purchase">Purchase</option>
                <option value="sales">Sales</option>
            </select>

            <label for="product_name">Product Name:</label>
            <input type="text" name="product_name" id="product_name" placeholder="Enter Product Name" required>

            <label for="quantity">Quantity:</label>
            <input type="number" name="quantity" id="quantity" placeholder="Enter Quantity" required>

            <label for="price">Price per Unit:</label>
            <input type="number" name="price" id="price" placeholder="Enter Price per Unit" required>

            <button type="submit">Save Report</button>
        </form>
    </div>
</body>
</html>
