<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include database connection
include 'db.php';
include 'sidebar.php';
// Fetch customers for the dropdown
$customerStmt = $pdo->query("SELECT customer_id, customer_name, address FROM customer_master");
$customers = $customerStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch branches for the dropdown
$branchStmt = $pdo->query("SELECT branch_id, branch_name, city FROM branch_master");
$branches = $branchStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch products for the dropdown
$productStmt = $pdo->query("SELECT product_id, product_name, mrp, stock FROM product_master");
$products = $productStmt->fetchAll(PDO::FETCH_ASSOC);

// Get current date
$currentDate = date('Y-m-d');

// Fetch the latest sale code and invoice number
$lastSaleStmt = $pdo->prepare("SELECT MAX(CAST(SUBSTRING(invoice_number, 5) AS UNSIGNED)) AS last_invoice_number FROM sales_transactions");
$lastSaleStmt->execute();
$lastSale = $lastSaleStmt->fetch(PDO::FETCH_ASSOC);
$lastNumber = $lastSale['last_invoice_number'] ?? 12;

$nextNumber = $lastNumber + 1;
$newInvoiceNumber = 'INV-' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
$newSaleCode = 'SC-' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Fetch POST data
    $product_id = $_POST['product_id'] ?? null;
   $customer_id = $_POST['customer_id'] ?? null;
    $sale_date = $_POST['sale_date'] ?? date('Y-m-d');
    $quantity = $_POST['quantity'] ?? [];
    $total_price = $_POST['total_price'] ?? 0;
    $sale_type = $_POST['sale_type'] ?? null;
    $receipt_status = $_POST['receipt_status'] ?? null;

    // Initialize arrays for book details
    $book_names = $_POST['book_name'] ?? [];
    $quantities = $_POST['quantity'] ?? [];
    $prices = $_POST['price'] ?? [];
    $amounts = $_POST['amount'] ?? [];

    $message = '';

    // Ensure books table data is valid
    if (empty($book_names) || count($quantities) !== count($book_names)) {
        $message = "Please ensure all book rows are filled out correctly.";
    } else {
        try {
            $pdo->beginTransaction(); // Start a transaction

            $sale_code = $newSaleCode;
            $invoice_number = $newInvoiceNumber;

            // Loop through each book row
            foreach ($book_names as $index => $book_id) {
                $quantity = $quantities[$index];
                $price = $prices[$index];
                $amount = $amounts[$index];

                $query = "
                    INSERT INTO sales_transactions 
                    (invoice_number, sale_code, product_id, customer_id, sale_date, quantity, total_price, sale_type, receipt_status) 
                    VALUES 
                    (:invoice_number, :sale_code, :product_id, :customer_id, :sale_date, :quantity, :total_price, :sale_type, :receipt_status)
                ";
                $stmt = $pdo->prepare($query);
                $stmt->execute([
                    ':invoice_number' => $invoice_number,
                    ':sale_code' => $sale_code,
                    ':product_id' => $book_id,
                    ':customer_id' => $customer_id,
                    ':sale_date' => $sale_date,
                    ':quantity' => $quantity,
                    ':total_price' => $amount,
                    ':sale_type' => $sale_type,
                    ':receipt_status' => $receipt_status,
                ]);
            }

            $pdo->commit(); // Commit the transaction
            $message = 'Sale transaction added successfully!';
        } catch (Exception $e) {
            $pdo->rollBack(); // Rollback on error
            $message = 'Error: ' . $e->getMessage();
        }
    }
}

 // Your existing code for handling form submissions
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Sale Transaction</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        h1 { margin-top: 20px; }
        .form-label { font-weight: bold; }
        .header-info { background-color: #e9ecef; padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .table-responsive { margin-top: 20px; }
        .btn-danger, .btn-primary { margin: 0; }
        .btn-danger { font-size: 0.8rem; }
        .radio-toggle { margin-bottom: 20px; }
        .radio-toggle .form-check-inline { margin-right: 15px; }
    .input-group {
        display: flex;
        align-items: center;
    }
    .add-book-btn {
        margin-left: 5px;
            height: 39px;
    }
    </style>
</head>
<body>
<div class="container">
    <h1 class="text-center">Add Sale Transaction</h1>
    
    <!-- Header Section -->
    <div class="header-info d-flex justify-content-between">
        <div><strong>Sale Code:</strong> <?= $newSaleCode ?></div>
        <div><strong>Invoice Number:</strong> <?= $newInvoiceNumber ?></div>
    </div>

    <!-- Success/Error Message -->
    <?php if ($message): ?>
        <div class="alert alert-success text-center" role="alert">
            <?= $message ?>
        </div>
    <?php endif; ?>

    <!-- Form Section -->
    <form action="" method="POST">
        <!-- Radio Buttons for Customer or Branch -->
        

        <div class="card p-4 mb-3 shadow-sm">
    <div class="d-flex justify-content-between align-items-center">
        <h3 class="mb-3 text-secondary">Sales Data</h3>
        <a href="add_branchsale.php" class="btn btn-primary">Add Branch Sale</a>
    </div>
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="sale_date" class="form-label">Sale Date</label>
                    <input type="date" id="sale_date" name="sale_date" class="form-control" value="<?= $currentDate ?>" required>
                </div>
                <div class="col-md-4">
                    <label for="entity_id" class="form-label" id="entity_label">Customer Name</label>
                     <div class="input-group">
                    <select id="entity_id" name="customer_id" class="form-control" required>
    <option value="">Select Customer</option>
    <?php foreach ($customers as $customer): ?>
        <option value="<?= $customer['customer_id'] ?>"><?= $customer['customer_name'] ?></option>
    <?php endforeach; ?>
</select>
<button class="btn btn-primary add-book-btn" type="button" onclick="window.location.href='customer_master.php';">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus-circle" viewBox="0 0 16 16">
                <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3a.5.5 0 0 1 .5-.5z"/>
                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0-1A6 6 0 1 0 8 2a6 6 0 0 0 0 12z"/>
            </svg>
        </button>
        </div>
                </div>
                <div class="col-md-4">
                    <label for="sale_type" class="form-label">Payment Type</label>
                    <select id="sale_type" name="sale_type" class="form-control" required>
                        <option value="">Select Payment Type</option>
                        <option value="cash">Cash</option>
                        <option value="card">Card</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Book List Section -->
        <div class="card p-4 shadow-sm">
            <h3 class="mb-3 text-secondary">Book List</h3>
            <!-- Keep your existing table code --><div class="table-responsive">
                <table class="table table-bordered table-striped" id="bookTable">
                    <thead class="table-primary">
                    <tr>
                        <th>S.No</th>
                        <th>Book Name</th>
                        <th>Quantity</th>
                        <th>Price</th>
                        <th>Amount</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>1</td>
                        <td>
                               <div class="input-group">
                            <select name="book_name[]" class="form-control bookName" required>
                                <option value="">Select Book</option>
                                <?php foreach ($products as $product): ?>
                                    <option value="<?= $product['product_id'] ?>" data-price="<?= $product['mrp'] ?>">
                                        <?= $product['product_name'] ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                             <button class="btn btn-primary add-book-btn" type="button" onclick="window.location.href='product_master.php';">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus-circle" viewBox="0 0 16 16">
                <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3a.5.5 0 0 1 .5-.5z"/>
                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0-1A6 6 0 1 0 8 2a6 6 0 0 0 0 12z"/>
            </svg>
        </button>
           </div>
                        </td>
                        <td>
                            <input type="number" name="quantity[]" class="form-control quantity" min="1" value="1" required>
                        </td>
                        <td>
                            <input type="text" name="price[]" class="form-control price" value="0.00" readonly>
                        </td>
                        <td>
                            <input type="text" name="amount[]" class="form-control amount" value="0.00" readonly>
                        </td>
                        <td>
                            <button type="button" class="btn btn-danger btn-sm deleteRow">Delete</button>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <button type="button" id="addRow" class="btn btn-primary mt-3">Add Book</button>
        </div>

        <!-- Submit Section -->
        <div class="text-end mt-4">
            <button type="submit" class="btn btn-success">Save Sale</button>
        </div>
    </form>
</div>


        </div>

        
    </form>
</div>

<script>
const products = <?= json_encode($products); ?>;

        function updateProductDetails() {
            const productSelect = document.getElementById('product_id');
            const selectedProductId = productSelect.value;

            const productDetails = products.find(p => p.product_id == selectedProductId);

            if (productDetails) {
                document.getElementById('product_mrp').textContent = `MRP: ₹${productDetails.mrp}`;
                document.getElementById('product_stock').textContent = `Stock: ${productDetails.stock} units`;
                calculateTotalAmount(productDetails.mrp);
            } else {
                document.getElementById('product_mrp').textContent = '';
                document.getElementById('product_stock').textContent = '';
            }
        }

        function calculateTotalAmount(mrp = null) {
            const quantity = document.getElementById('quantity').value;
            const total = quantity * (mrp || 0);
            document.getElementById('total_amount').textContent = `₹${total.toFixed(2)}`;
        }
        document.addEventListener('DOMContentLoaded', () => {
    const bookTable = document.getElementById('bookTable').getElementsByTagName('tbody')[0];
    const totalAmountElement = document.getElementById('totalAmount');

    // Automatically set the first row with existing data if available
    const firstRow = bookTable.rows[0];
    const firstProductSelect = firstRow.querySelector('.bookName');
    const firstPriceField = firstRow.querySelector('.price');
    const firstAmountField = firstRow.querySelector('.amount');
    const firstQuantityField = firstRow.querySelector('.quantity');

    if (firstProductSelect) {
        const selectedOption = firstProductSelect.options[firstProductSelect.selectedIndex];
        const price = parseFloat(selectedOption.getAttribute('data-price')) || 0;
        const quantity = parseFloat(firstQuantityField.value) || 1;
        const amount = price * quantity;

        firstPriceField.value = price.toFixed(2);
        firstAmountField.value = amount.toFixed(2);
    }

    // Function to calculate and update total
    function updateTotal() {
        let total = 0;
        document.querySelectorAll('.amount').forEach(amountField => {
            const amount = parseFloat(amountField.value) || 0;
            total += amount;
        });
        totalAmountElement.textContent = total.toFixed(2);
    }
    
    // Update individual row calculations
    function updateRow(row) {
        const productSelect = row.querySelector('.bookName');
        const quantityField = row.querySelector('.quantity');
        const priceField = row.querySelector('.price');
        const amountField = row.querySelector('.amount');

        const selectedOption = productSelect.options[productSelect.selectedIndex];
        const price = parseFloat(selectedOption.getAttribute('data-price')) || 0;
        const quantity = parseFloat(quantityField.value) || 0;
        const amount = price * quantity;

        priceField.value = price.toFixed(2);
        amountField.value = amount.toFixed(2);
        updateTotal();
    }

    bookTable.addEventListener('change', (e) => {
        if (e.target.classList.contains('bookName') || e.target.classList.contains('quantity')) {
            updateRow(e.target.closest('tr'));
        }
    });

    bookTable.addEventListener('input', (e) => {
        if (e.target.classList.contains('quantity')) {
            updateRow(e.target.closest('tr'));
        }
    });

    // Add a new row
    document.getElementById('addRow').addEventListener('click', () => {
        const newRow = bookTable.insertRow();
        const rowIndex = bookTable.rows.length;

        newRow.innerHTML = `
            <td>${rowIndex}</td>
            <td>
                <select name="book_name[]" class="bookName" style="width: 95%; padding: 5px;" required>
                    <option value="">Select Book</option>
                    <?php foreach ($products as $product): ?>
                        <option value="<?= $product['product_id'] ?>" data-price="<?= $product['mrp'] ?>">
                            <?= $product['product_name'] ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
            <td>
                <input type="number" name="quantity[]" class="quantity" style="width: 90%; padding: 5px;" min="1" value="1" required>
            </td>
            <td>
                <input type="text" name="price[]" class="price" style="width: 90%; padding: 5px;" readonly>
            </td>
            <td>
                <input type="text" name="amount[]" class="amount" style="width: 90%; padding: 5px;" readonly>
            </td>
            <td>
<button type="button" class="btn btn-danger btn-sm deleteRow">Delete</button>
            </td>
        `;
    });

    // Delete row
    bookTable.addEventListener('click', (e) => {
        if (e.target.closest('.deleteRow')) {
            const row = e.target.closest('tr');
            row.parentNode.removeChild(row);
            updateTotal();
        }
    });
});


document.addEventListener('DOMContentLoaded', () => {
    const entityTypeRadios = document.querySelectorAll('.toggle-option');
    const entityLabel = document.getElementById('entity_label');
    const entitySelect = document.getElementById('entity_id');

    const customerOptions = <?= json_encode($customers) ?>;
    const branchOptions = <?= json_encode($branches) ?>;

    entityTypeRadios.forEach(radio => {
        radio.addEventListener('change', () => {
            if (radio.checked) {
                const isCustomer = radio.value === 'customer';
                entityLabel.textContent = isCustomer ? 'Customer Name' : 'Branch Name';
                entitySelect.innerHTML = ''; // Clear current options
                
                const options = isCustomer ? customerOptions : branchOptions;
                options.forEach(option => {
                    const opt = document.createElement('option');
                    opt.value = isCustomer ? option.customer_id : option.branch_id;
                    opt.textContent = isCustomer ? option.customer_name : option.branch_name;
                    entitySelect.appendChild(opt);
                });
            }
        });
    });
});
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
