<?php
// Include database connection
include 'db.php';

// Fetch customers for the dropdown
$customersStmt = $pdo->query("SELECT customer_id, customer_name FROM customer_master");
$customers = $customersStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch products for the dropdown
$productsStmt = $pdo->query("SELECT product_id, product_name FROM product_master");
$products = $productsStmt->fetchAll(PDO::FETCH_ASSOC);

$currentDate = date('Y-m-d');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $customer_id = $_POST['customer_id'];
    $product_id = $_POST['product_id'];
    $quantity = $_POST['quantity'];
    $price_per_unit = $_POST['price_per_unit'];
    $sale_date = $_POST['sale_date'];

    // Calculate total amount
    $total_price = $quantity * $price_per_unit;

    try {
        // Insert new sale report into the database
        $stmt = $pdo->prepare("
            INSERT INTO sales_reports 
            (customer_id, product_id, quantity, price_per_unit, total_price, sale_date) 
            VALUES (:customer_id, :product_id, :quantity, :price_per_unit, :total_price, :sale_date)
        ");
        $stmt->execute([
            ':customer_id' => $customer_id,
            ':product_id' => $product_id,
            ':quantity' => $quantity,
            ':price_per_unit' => $price_per_unit,
            ':total_price' => $total_price,
            ':sale_date' => $sale_date,
        ]);

        $message = "Sale report added successfully!";
    } catch (Exception $e) {
        $message = "Error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Sale Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f5f5f5;
            padding: 20px;
        }

        .container {
            max-width: 700px;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        h1 {
            text-align: center;
            color: #333;
        }

        form {
            margin-top: 20px;
        }

        label {
            display: block;
            margin-top: 15px;
            font-weight: bold;
        }

        input, select {
            width: 100%;
            padding: 10px;
            margin-top: 5px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        .btn {
            display: block;
            width: 100%;
            padding: 10px;
            margin-top: 20px;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }

        .btn:hover {
            background-color: #0056b3;
        }

        .message {
            text-align: center;
            color: green;
            margin: 15px 0;
            font-size: 16px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Add Sale Report</h1>

        <?php if (isset($message)): ?>
            <p class="message"><?= htmlspecialchars($message) ?></p>
        <?php endif; ?>

        <form action="" method="POST">
            <label for="customer_id">Customer Name</label>
            <select name="customer_id" id="customer_id" required>
                <option value="">Select Customer</option>
                <?php foreach ($customers as $customer): ?>
                    <option value="<?= $customer['customer_id'] ?>"><?= htmlspecialchars($customer['customer_name']) ?></option>
                <?php endforeach; ?>
            </select>

            <label for="product_id">Product Name</label>
            <select name="product_id" id="product_id" required>
                <option value="">Select Product</option>
                <?php foreach ($products as $product): ?>
                    <option value="<?= $product['product_id'] ?>"><?= htmlspecialchars($product['product_name']) ?></option>
                <?php endforeach; ?>
            </select>

            <label for="quantity">Quantity</label>
            <input type="number" id="quantity" name="quantity" required min="1" placeholder="Enter quantity">

            <label for="price_per_unit">Price Per Unit (₹)</label>
            <input type="number" id="price_per_unit" name="price_per_unit" required step="0.01" placeholder="Enter price per unit">

            <label for="sale_date">Sale Date</label>
            <input type="date" id="sale_date" name="sale_date" value="<?= $currentDate ?>" required>

            <button type="submit" class="btn">Add Sale Report</button>
        </form>
    </div>
</body>
</html>
