<?php
include 'db.php'; // Database connection
include 'sidebar.php';
// Handle form submission for adding a new branch
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize user input
    $branch_name = $_POST['branch_name'];
    $city = $_POST['city'];
    $contact_person_name = $_POST['contact_person_name'];
    $contact_person_mobile = $_POST['contact_person_mobile'];
    $email = $_POST['email'];

   try {
    // Insert data into the branch_master table
    $query = "INSERT INTO branch_master (branch_name, city, contact_person_name, contact_person_mobile, email) 
              VALUES (:branch_name, :city, :contact_person_name, :contact_person_mobile, :email)";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':branch_name', $branch_name);
    $stmt->bindParam(':city', $city);
    $stmt->bindParam(':contact_person_name', $contact_person_name);
    $stmt->bindParam(':contact_person_mobile', $contact_person_mobile);
    $stmt->bindParam(':email', $email);

    // Execute the statement
    $stmt->execute();

    // Redirect back to branch_master.php
    header('Location: branch_master.php');
    exit();
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Branch Master</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
   
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        h2 {
            text-align:center;
            margin-top: 20px;
        }
        form {
            margin-top: 20px;
        }
          table {
            width: 100%;
            border-collapse: collapse;
            border-radius: 8px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
        }
        th {
            background: #007bff;
        }
        td {
            text-align: left;
        }
        tr:nth-child(even) {
            background-color:rgb(242, 242, 242);
        }
        td:nth-child(4) {
            text-align: left;
        }
        td:nth-child(5) {
            text-align: left;
        }
        td:nth-child(6) {
            text-align: left;
        }
        td:nth-child(7) {
            text-align: left;
        }
        tr:hover {
            background-color: #f1f1f1;
        }


    </style>
    <div class="container mt-5">
        <h2>Branch Master</h2>
        
        

        <!-- Add New Branch Button -->
        <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addBranchModal"><svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-plus-circle-fill" viewBox="0 0 16 16">
  <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0M8.5 4.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3z"/>
</svg></button>
        
        <!-- Branch Table -->
        <table >
            <thead>
                <tr>
                    <th>#</th>
                    <th>Branch Name</th>
                    <th>Address</th>
                    <th>Contact Person Name</th>
                    <th>Contact Person Mobile</th>
                    <th>Email ID</th>
                 
                </tr>
            </thead>
            <tbody>
                <?php
                // Fetch all branches from the database
                $query = "SELECT * FROM branch_master";
                $branches = $pdo->query($query)->fetchAll();
                if (!empty($branches)) {
                    foreach ($branches as $index => $branch) {
                        echo "<tr>
                                <td>" . ($index + 1) . "</td>
                                <td>" . htmlspecialchars($branch['branch_name']) . "</td>
                                <td>" . htmlspecialchars($branch['city']) . "</td>
                                <td>" . htmlspecialchars($branch['contact_person_name']) . "</td>
                                <td>" . htmlspecialchars($branch['contact_person_mobile']) . "</td>
                                <td>" . htmlspecialchars($branch['email']) . "</td>
                               
                            </tr>";
                    }
                } else {
                    echo "<tr><td colspan='6' class='text-center'>No Branches Found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <!-- Add Branch Modal -->
    <div class="modal fade" id="addBranchModal" tabindex="-1" aria-labelledby="addBranchModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="branch_master.php" method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addBranchModalLabel">Add New Branch</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="branch_name" class="form-label">Branch Name</label>
                            <input type="text" class="form-control" id="branch_name" name="branch_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="city" class="form-label">City</label>
                            <input type="text" class="form-control" id="city" name="city" required>
                        </div>
                        <div class="mb-3">
                            <label for="contact_person_name" class="form-label">Contact Person Name</label>
                            <input type="text" class="form-control" id="contact_person_name" name="contact_person_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="contact_person_mobile" class="form-label">Contact Person Mobile</label>
                            <input type="text" class="form-control" id="contact_person_mobile" name="contact_person_mobile" required>
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label">Email ID</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>

                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Save</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
