<?php
include 'db.php';
include 'sidebar.php'; // Database connection

// Handle form submission for adding a new customer
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize user input
    $customer_name = $_POST['customer_name'];
    $phone_number = $_POST['phone_number'];
    $email_id = $_POST['email_id'];
    $address = $_POST['address'];

    try {
        // Insert data into the customer_master table
        $query = "INSERT INTO customer_master (customer_name, phone_number, customer_mail, address) VALUES (:customer_name, :phone_number, :email_id, :address)";
        $stmt = $pdo->prepare($query);
        // Bind parameters correctly
        $stmt->bindParam(':customer_name', $customer_name);
        $stmt->bindParam(':phone_number', $phone_number);
        $stmt->bindParam(':email_id', $email_id);
        $stmt->bindParam(':address', $address);
        
        $stmt->execute();

        // Redirect back to customer_master.php to avoid form resubmission
        header('Location: customer_master.php');
        exit();
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Master</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
    <style>
      body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
    
        h2{
            color: #343a40;
            margin-top: 20px;
            margin-bottom: 20px;
            text-align: center;
            font-weight: bold;
           
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
          table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
          
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
        }
        th {
            background: #007bff;
        }
        td {
            text-align: left;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        td:nth-child(4) {
            text-align: right;
        }
        td:nth-child(5) {
            text-align: left;
        }
        td:nth-child(6) {
            text-align: left;
        }
        td:nth-child(7) {
            text-align: left;
        }
        tr:hover {
            background-color: #f1f1f1;
        }


    </style>
    <div class="container mt-5">
        <h2>Customer Master</h2>
        
        <!-- Add New Customer Button -->
        

        <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addCustomerModal" ><svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-plus-circle-fill" viewBox="0 0 16 16">
  <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0M8.5 4.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3z"/>
</svg></button>
        
        <!-- Customer Table -->
        <table >
            <thead>
                <tr>
                    <th>#</th>
                    <th>Customer Name</th>
                    <th>Phone Number</th>
                    <th>Address</th>
                    <th>Email</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Fetch all customers from the database
                $query = "SELECT * FROM customer_master";
                $customers = $pdo->query($query)->fetchAll();
                if (!empty($customers)) {
                    foreach ($customers as $index => $customer) {
                        echo "<tr>
                                <td>" . ($index + 1) . "</td>
                                <td>" . htmlspecialchars($customer['customer_name']) . "</td>
                                <td>" . htmlspecialchars($customer['phone_number']) . "</td>
                                <td>" . htmlspecialchars($customer['address'])."</td>
                                <td>" . htmlspecialchars($customer['customer_mail'])."</td>
                            </tr>";
                    }
                } else {
                    echo "<tr><td colspan='3' class='text-center'>No Customers Found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <!-- Add Customer Modal -->
    <div class="modal fade" id="addCustomerModal" tabindex="-1" aria-labelledby="addCustomerModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="customer_master.php" method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addCustomerModalLabel">Add New Customer</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="customer_name" class="form-label">Customer Name</label>
                            <input type="text" class="form-control" id="customer_name" name="customer_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="phone_number" class="form-label">Phone Number</label>
                            <input type="text" class="form-control" id="phone_number" name="phone_number" required>
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="email" name="email_id" required>
                        </div>
                        <div class="mb-3">
                            <label for="address" class="form-label">Address</label>
                            <textarea class="form-control" id="address" name="address" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Save</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
