<?php
session_start();
include 'db.php';

header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['category_id'])) {
    $categoryId = $_POST['category_id'];

    try {
        // Fetch books based on selected category
        $stmt = $pdo->prepare("SELECT product_name, stock FROM product_master WHERE category_id = ?");
        $stmt->execute([$categoryId]);
        $books = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($books) {
            echo json_encode($books);
        } else {
            echo json_encode(["error" => "No books found for this category."]);
        }
    } catch (PDOException $e) {
        echo json_encode(["error" => "Database error: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["error" => "Invalid request."]);
}
?>
