<?php
require 'db.php';

// Fetch purchase numbers based on supplier selection
if (isset($_POST['supplier_id'])) {
    $supplier_id = $_POST['supplier_id'];
    
    // Check if the supplier exists in the database
    $checkSupplier = $pdo->prepare("SELECT supplier_id FROM supplier_master WHERE supplier_id = ?");
    $checkSupplier->execute([$supplier_id]);
    $supplierExists = $checkSupplier->fetchColumn();
    
    if ($supplierExists) {
        $query = "SELECT DISTINCT purchase_number 
                  FROM purchase_transactions 
                  WHERE supplier_id = ?";
        $stmt = $pdo->prepare($query);
        $stmt->execute([$supplier_id]);
        $purchases = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        if ($purchases) {
            echo '<option value="">-- Select Purchase Number --</option>';
            foreach ($purchases as $purchase) {
                echo '<option value="' . $purchase['purchase_number'] . '">' . $purchase['purchase_number'] . '</option>';
            }
        } else {
            echo '<option value="">No purchases found for this supplier</option>';
        }
    } else {
        echo '<option value="">Supplier not found</option>';
    }
    exit;
}
?>


