<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
include 'db.php'; 

// If Admin is not logged in, redirect to login
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin_login.php");
    exit();
}

try {
    // Total Books Count
    $bookCountQuery = $pdo->query("SELECT COUNT(*) AS total_books FROM product_master");
    $totalBooks = $bookCountQuery->fetch(PDO::FETCH_ASSOC)['total_books'];

    // Total Stock Count
    $stockQuery = $pdo->query("SELECT SUM(stock) AS total_stock FROM product_master");
    $totalStock = $stockQuery->fetch(PDO::FETCH_ASSOC)['total_stock'];


    // Total Purchases
 $stmt = $pdo->query("SELECT SUM(total_amount) AS total_sales FROM sales_transactions");
$totalSales = $stmt->fetch(PDO::FETCH_ASSOC)['total_sales'] ?? 0;

// Fetch Total Purchases
$stmt = $pdo->query("SELECT SUM(total_amount) AS total_purchases FROM purchase_transactions");
$totalPurchases = $stmt->fetch(PDO::FETCH_ASSOC)['total_purchases'] ?? 0;
echo "Total Sales: ₹ " . number_format((float) $totalSales, 2) . "<br>";

// Fetch Total Purchases
echo "Total Purchases: ₹ " . number_format((float) $totalPurchases, 2);
    // Categories
    $categoriesQuery = $pdo->query("SELECT category_name FROM category_master");
    $categories = $categoriesQuery->fetchAll(PDO::FETCH_ASSOC);
    
    if (isset($_POST['category_id'])) {
        $categoryId = $_POST['category_id'];
        $booksQuery = $pdo->prepare("SELECT product_name FROM product_master WHERE category_id = ?");
        $booksQuery->execute([$categoryId]);
        $books = $booksQuery->fetchAll(PDO::FETCH_ASSOC);
        
        foreach ($books as $book) {
            echo "<li class='list-group-item'>{$book['product_name']}</li>";
        }
        exit();
    }

} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
$categoriesQuery = $pdo->query("SELECT category_id, category_name FROM category_master");
$categories = $categoriesQuery->fetchAll(PDO::FETCH_ASSOC);

// Separate "Books" and "Others" categories
$booksCategory = [];
$othersCategory = [];

foreach ($categories as $category) {
    if (in_array($category['category_id'], [1, 2, 3])) {  // Tamil: 1, English: 2, Hindi: 3
        $booksCategory[] = $category;
    } else {
        $othersCategory[] = $category;
    }
}


// Fetch Total Purchases
try {
    $stmt = $pdo->query("SELECT COALESCE(SUM(total_cost), 0) AS total_purchases FROM purchase_transactions");
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $totalPurchases = (float) $row['total_purchases']; // Ensure it's a valid float
} catch (PDOException $e) {
    $totalPurchases = 0;
}

$currentDate = date('Y-m-d');

// Total Sales Today
$stmt = $pdo->prepare("SELECT SUM(total_price) AS total_sales FROM sales_transactions WHERE DATE(sale_date) = :current_date");
$stmt->bindParam(':current_date', $currentDate);
$stmt->execute();
$totalSalesToday = $stmt->fetch(PDO::FETCH_ASSOC)['total_sales'] ?? 0;

// Total Purchases Today
$stmt = $pdo->prepare("SELECT SUM(total_cost) AS total_purchases FROM purchase_transactions WHERE DATE(purchase_date) = :current_date");
$stmt->bindParam(':current_date', $currentDate);
$stmt->execute();
$totalPurchasesToday = $stmt->fetch(PDO::FETCH_ASSOC)['total_purchases'] ?? 0;



?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
     <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).on('change', '#categorySelect', function() {
    var categoryId = $(this).val();
    
    $.ajax({
        url: 'fetch_book.php',
        type: 'POST',
        data: { category_id: categoryId },
        dataType: 'json',
        success: function(response) {
            var bookList = $('#bookList');
            bookList.empty();
            
            if (response.error) {
                bookList.append('<li class="list-group-item text-danger">' + response.error + '</li>');
            } else {
                response.forEach(function(book) {
                    bookList.append('<li class="list-group-item"><strong>' + book.product_name + '</strong> - Stock: ' + book.stock + '</li>');
                });
            }
        },
        error: function() {
            $('#bookList').html('<li class="list-group-item text-danger">Failed to fetch books.</li>');
        }
    });
});
$query = "SELECT category_id, category_name FROM category_master";
$result = mysqli_query($conn, $query);

// Check if query succeeded
if ($result && mysqli_num_rows($result) > 0) {
    while ($category = mysqli_fetch_assoc($result)) {
        echo '<li class="list-group-item category-item" 
                data-id="' . htmlspecialchars($category['category_id']) . '" 
                style="cursor:pointer;">
                ' . htmlspecialchars($category['category_name']) . '
              </li>';
    }
} else {
    echo '<li class="list-group-item text-danger">No categories found</li>';
}
</script>


    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
    $('#categorySelect').on('change', function () {
        var categoryId = $(this).val();

        if (categoryId) {
            $.ajax({
                url: 'fetch_book.php',
                type: 'POST',
                data: { category_id: categoryId },
                dataType: 'json',
                success: function (response) {
                    var bookList = $('#bookList');
                    bookList.empty();

                    if (response.error) {
                        bookList.append('<li class="list-group-item text-danger">' + response.error + '</li>');
                    } else {
                        response.forEach(function (book) {
                            bookList.append('<li class="list-group-item"><strong>' + book.product_name + '</strong> - Stock: ' + book.stock + '</li>');
                        });
                    }
                },
                error: function () {
                    $('#bookList').html('<li class="list-group-item text-danger">Failed to fetch books.</li>');
                }
            });
        } else {
            $('#bookList').html('<li class="list-group-item text-warning">Please select a category.</li>');
        }
    });
});
</script>

    <style>
        /* Sidebar custom styles */
        /* Sidebar Styles */
.sidebar {
    width: 270px;
     /* Full height */
    background: linear-gradient(135deg, #6a11cb, #2575fc);
    display: flex;
    flex-direction: column;
    position: fixed;
    top: 0;
    left: 0;
    padding: 20px;
        min-height: 300vh; /* Ensures the sidebar takes full viewport height */

}

/* Make menu scrollable */
.scrollable-menu {
    flex-grow: 1; /* Takes available space */
    max-height: 60vh; /* Set max height */
    overflow-y: auto; /* Enable scrolling */
    margin-bottom: 10px; /* Space before footer */
}

/* Sidebar Footer */
.sidebar-footer {
    text-align: center;
  
    padding: 10px 0;
    border-top: 1px solid #fff;
        

}


/* Main content should not be affected */
.main-content {
    margin-left: 270px; /* Sidebar width */
    padding: 20px;
    width: calc(100% - 270px); /* Adjust width */
}


        .sidebar img {
            width: 80px;
            margin-bottom: 10px;
            border-radius: 50%;
        }

        .sidebar h1 {
            font-size: 20px;
            color: #fff;
            text-align: center;
            margin: 0 0 20px 0;
        }

        .nav-link {
            color: #f8f9fa;
            font-size: 16px;
            padding: 10px 15px;
            margin-bottom: 5px;
            border-radius: 4px;
            transition: all 0.3s ease;
        }

        .nav-link:hover {
            background-color: white;
            text-decoration: none;
            width: 201px;
        }

        .sub-menu {
            margin-top: 10px;
            padding-left: 20px;
        }

        .sub-menu a {
            color: #dcdcdc;
            font-size: 14px;
        }

        .sub-menu a:hover {
            color: #ffffff;
        }

        .nav-item {
            margin-bottom: 15px;
        }

        /* Scrollable menu section */
        .scrollable-menu {
            flex-grow: 1; /* Take up remaining space */
            overflow-y: auto; /* Enable vertical scrolling */
            margin-bottom: 20px; /* Space between menu and footer */
        }

        .sidebar-footer {
            text-align: center;
            padding: 10px 0;
            border-top: 1px solid #fff;
                background: white;
        }

        .sidebar-footer img {
            width: 139px;
            margin-bottom: 10px;
            border-radius: 0px;
        }

        .sidebar-footer p {
            font-size: 14px;
            color: #fff;
            margin: 0;
        }

        /* Main content adjustment */
        .main-content {
            margin-left: 270px; /* Sidebar width */
            padding: 20px;
            width: calc(100% - 270px); /* Adjust width */
        }
        a {
    color: rgb(255 255 255);
    text-decoration: none;
}
/* Position the logout button to the top-right */
.logout-button {
    width: 40px;
    position: fixed;
    top: 20px; /* Adjust to your preference */
    right: 20px; /* Adjust to your preference */
    border: none;
    cursor: pointer;
    text-decoration: none;
    font-weight: 500;
}

    </style>
</head>
<body>
     <div class="d-flex">
        <!-- Sidebar -->
        <div class="sidebar">
            <!-- Header Section (Static) -->
            <div>
                <div class="text-center">
                    <img src="images/logo.webp" alt="Vivekananda Bookstall">
                    <h1>Tatvamasi Book Center</h1>
                </div>

                <!-- Scrollable Menu Section -->
                <div class="scrollable-menu">
                    <ul class="nav flex-column">
                        <!-- Masters Menu -->
                        <li class="nav-item">
                            <a href="#" class="nav-link"><i class="fas fa-cogs"></i> Masters</a>
                            <ul class="list-unstyled sub-menu">
                                <li><a href="supplier_master.php"><i class="fas fa-industry"></i> Supplier Master</a></li>
                                <li><a href="customer_master.php"><i class="fas fa-user"></i> Customer Master</a></li>
                                <li><a href="category_master.php"><i class="fas fa-tags"></i> Category Master</a></li>
                                <li><a href="branch_master.php"><i class="fas fa-building"></i> Branch Master</a></li>
                                <li><a href="product_master.php"><i class="fas fa-book"></i> Book Master</a></li>
                            </ul>
                        </li>

                        <!-- Transaction History Menu -->
                        <li class="nav-item">
                            <a href="transaction_history.php" class="nav-link"><i class="fas fa-history"></i> Transaction History</a>
                            <ul class="list-unstyled sub-menu">
                                <li><a href="transaction_history.php"><i class="fas fa-shopping-cart"></i> Purchase</a></li>
                                <li>
                                    <a href="sales.php"><i class="fas fa-dollar-sign"></i> Sales</a>
                                        <li><a href="branch_sales.php"><i class="fas fa-store"></i> Branch Sales</a></li>
                                </li>
                                </li>
                                </ul>
                                <li class="nav-item">
                            <a href="receipt.php" class="nav-link"><i class="fas fa-chart-line"></i> Receipt</a>
                            <ul class="list-unstyled sub-menu">
                                <li><a href="receipt_status.php"><i class="fas fa-receipt"></i> Receipt Status</a></li>
                        </li>
                        </ul>
                                 <li class="nav-item">
                                <a href="#" class="nav-link"><i class="fas fa-reply"></i> Returns</a>
                                <ul class="list-unstyled sub-menu">
                                <li><a href="returns.php"><i class="fa fa-undo"></i> Purchase Returns</a></li>
                                <li><a href="sales_returns.php"><i class="fa fa-undo"></i> Sales Retrurns</a></li>
                            </ul>
                        </li>
                        </li>

                        <!-- Reports Menu -->
                        <li class="nav-item">
                            <a href="#" class="nav-link"><i class="fas fa-chart-line"></i> Reports</a>
                            <ul class="list-unstyled sub-menu">
                                <li><a href="stock_report.php"><i class="fas fa-warehouse"></i> Stock Report</a></li>
                                <li><a href="purchase_report.php"><i class="fas fa-truck-loading"></i> Purchase Report</a></li>
                                <li><a href="sales_report.php"><i class="fas fa-chart-bar"></i> Sales Report</a></li>
                            </ul>
                        </li>
                        
                         
                    </ul>
                   
                </div>
            </div>

            
   
            <div class="sidebar-footer">
                <a href="https://kalpavrukshaits.com/">
               <img src="images/logo.jpg" alt="Footer Logo"></a>
                
            </div>
        </div>

        <!-- Main Content -->
        <div class="main-content">
           <!-- Add the logout button at the top-right of the page -->
<a href="logout.php">
</h2><img src="images/shutdown.png" alt="logoutimg" class="logout-button"></a>
            <h2>Welcome to the Admin Dashboard</h2><br><br>
             
            <div class="row">
                <div class="col-md-3">
                    <div class="card text-white bg-primary mb-3">
                        <div class="card-body">
                            <a href="stock_report.php">
                            <h5 class="card-title">Total Books</h5>
                            <p class="card-text"> <?= $totalBooks ?> </p></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card text-white bg-success mb-3">
                        <a href="stock_report.php">
                        <div class="card-body">
                            <h5 class="card-title">Total Stock</h5>
                            <p class="card-text"> <?= $totalStock ?> </p>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card text-white bg-warning mb-3">
                        <div class="card-body">
                            <h5 class="card-title">Total Purchases</h5>
                            <p class="card-text"> ₹<?php echo number_format($totalPurchases, 2); ?> </p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card text-white bg-danger mb-3">
                        <div class="card-body">
                            <h5 class="card-title">Total Sales</h5>
                            <p class="card-text"> ₹<?php echo number_format($totalSales, 2); ?> </p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="card mb-3">
                    <div class="container mt-4">
    <h4>Book Category</h4>
    <select id="categorySelect" class="form-control">
        <option value="">Select a category</option>
        <?php foreach ($categories as $category): ?>
            <option value="<?= $category['category_id']; ?>"><?= htmlspecialchars($category['category_name']); ?></option>
        <?php endforeach; ?>
    </select>

    <h4 class="mt-3">Books</h4>
    <ul id="bookList" class="list-group"></ul>
</div>

        </div>
    </div>
    <div class="col-md-3">
    <div class="card text-white bg-info mb-3">
        <div class="card-body">
            <h5 class="card-title">Today's Purchases</h5>
            <p class="card-text"> ₹<?php echo number_format($totalPurchasesToday, 2); ?> </p>
        </div>
    </div>
</div>
<div class="col-md-3">
    <div class="card text-white bg-secondary mb-3">
        <div class="card-body">
            <h5 class="card-title">Today's Sales</h5>
            <p class="card-text"> ₹<?php echo number_format($totalSalesToday, 2); ?> </p>
        </div>
    </div>
</div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
   
</body>
</html>
