<?php
include 'sidebar.php';
// Database connection (update your credentials)
$host = 'localhost';
$db = 'bookstore_dashboard';
$user = 'bookstore_dashboard';
$pass = '9(AhSb@uHXMUk0wK';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// Handle form submission (insert new product record)
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_product'])) {
    try {
        $product_name = $_POST['product_name'];
        $category_id = $_POST['category_id'];
        $author = $_POST['author'];
        $year_of_publication = $_POST['year_of_publication'];
        $mrp = $_POST['mrp'];
        $price = $_POST['price']; // Fetch the price value

      $sql = "INSERT INTO product_master (product_name, category_id, author, year_of_publication, mrp, price) 
        VALUES (:product_name, :category_id, :author, :year_of_publication, :mrp, :price)";

        $stmt = $pdo->prepare($sql);

        $stmt->execute([
            ':product_name' => $product_name,
            ':category_id' => $category_id,
            ':author' => $author,
            ':year_of_publication' => $year_of_publication,
            ':mrp' => $mrp,
            ':price' => $price
        ]);

        echo "<p>New product added successfully!</p>";
    } catch (PDOException $e) {
        echo "Error while adding product: " . $e->getMessage();
    }
}




// Fetch all product records
$sql = "SELECT * FROM product_master ORDER BY product_id ASC";
$stmt = $pdo->query($sql);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    

    <title>Book Master</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color:rgb(28, 139, 230);
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        form {
            margin-top: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
        }
    
        
        .form-container {
            display: none;
            margin-bottom: 20px;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            background-color: #f9f9f9;
        }
        .form-container.active {
            display: block;
        }
        .form-control {
            margin-bottom: 10px;
        }
        .form-control label {
            display: block;
            margin-bottom: 5px;
        }
        .form-control input, .form-control select {
            width: 100%;
            padding: 8px;
            box-sizing: border-box;
            border-radius: 5px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            margin-top: 15px;
            margin-bottom: 20px;
            font-weight: bold;
            font-size: 16px;
        }
         button {
            padding: 10px 15px;
            background-color: #28a745;
            color: #fff;
            border: none;
            cursor: pointer;
        }
        .form-control button:hover {
            background-color: #218838;
        }
        .toggle-button {
            margin-bottom: 20px;
            padding: 10px 15px;
            background-color: #007bff;
            color: #fff;
            border: none;
            cursor: pointer;
            border-radius: 5px;
        }
        .toggle-button:hover {
            background-color: #0056b3;
        }
    </style>
    <script>
        function toggleForm() {
            const formContainer = document.querySelector('.form-container');
            formContainer.classList.toggle('active');
        }
    </script>
</head>
<body>
    <h1>Book Master</h1>


    <!-- Button to Trigger the Add Product Modal -->
    <button type="button" class="toggle-button" data-bs-toggle="modal" data-bs-target="#addProductModal">
        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-plus-circle-fill" viewBox="0 0 16 16">
            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0M8.5 4.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3z"/>
        </svg>
    </button>

    <!-- Modal for Product Entry Form -->
    <div class="modal fade" id="addProductModal" tabindex="-1" aria-labelledby="addProductModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addProductModalLabel">Add New Product</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                   <form method="POST">
    <div class="mb-3">
        <label for="product_name" class="form-label">Product Name</label>
        <input type="text" class="form-control" id="product_name" name="product_name" required>
    </div>
    <div class="mb-3">
        <label for="category_id" class="form-label">Category ID</label>
        <input type="number" class="form-control" id="category_id" name="category_id" required>
    </div>
    <div class="mb-3">
        <label for="author" class="form-label">Author</label>
        <input type="text" class="form-control" id="author" name="author" required>
    </div>
    <div class="mb-3">
        <label for="year_of_publication" class="form-label">Year of Publication</label>
        <input type="number" class="form-control" id="year_of_publication" name="year_of_publication" required>
    </div>
    <div class="mb-3">
        <label for="mrp" class="form-label">MRP</label> <!-- MRP Field -->
        <input type="number" step="0.01" class="form-control" id="mrp" name="mrp" required>
    </div>
    <div class="mb-3">
        <label for="price" class="form-label">Price</label> <!-- Price Field -->
        <input type="number" step="0.01" class="form-control" id="price" name="price" required>
    </div>
    <button type="submit" class="btn btn-success w-100" name="add_product">Add Product</button>
</form>

                </div>
            </div>
        </div>
    </div>
     <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Product Table -->
   <!-- Product Table -->
<?php if ($products && count($products) > 0): ?>
    <table>
        <thead>
            <tr>
                <th>Product ID</th>
                <th>Product Name</th>
                <th>Category ID</th>
                <th>Author</th>
                <th>Year of Publication</th>
                <th>MRP</th>
                <th>Price</th> <!-- Added -->
            </tr>
        </thead>
        <tbody>
            <?php foreach ($products as $product): ?>
                <tr>
                    <td><?= $product['product_id'] ?></td>
                    <td><?= $product['product_name'] ?></td>
                    <td><?= $product['category_id'] ?></td>
                    <td><?= $product['author'] ?></td>
                    <td><?= $product['year_of_publication'] ?></td>
                    <td><?= $product['mrp'] ?></td>
                    <td><?= $product['price'] ?></td> <!-- Added -->
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>No products found.</p>
<?php endif; ?>

</body>
</html>