<?php
// Database Connection
$host = 'localhost';
$db = 'bookstore_dashboard';
$user = 'bookstore_dashboard';
$pass = '9(AhSb@uHXMUk0wK';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// Fetch Purchase History
$query = "SELECT 
    p.purchase_id,
    p.purchase_date,
    COUNT(p.item_id) AS total_items,
    SUM(p.quantity) AS total_quantity,
    SUM(p.quantity * p.price) AS total_amount
    FROM purchase p
    GROUP BY p.purchase_id, p.purchase_date
    ORDER BY p.purchase_date DESC";

$stmt = $pdo->prepare($query);
$stmt->execute();
$purchases = $stmt->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Purchase History</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ccc;
        }
        th, td {
            padding: 10px;
            text-align: center;
        }
        th {
            background-color: #007bff;
            color: white;
        }
        .btn {
            text-decoration: none;
            padding: 8px 12px;
            background-color: #007bff;
            color: white;
            border-radius: 5px;
            cursor: pointer;
        }
        .btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <h1>Purchase History</h1>
    <a href="add_purchase.php" class="btn">Add New Purchase</a>
    <table>
        <thead>
            <tr>
                <th>Purchase ID</th>
                <th>Purchase Date</th>
                <th>Total Items</th>
                <th>Total Quantity</th>
                <th>Total Amount</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($purchases as $purchase): ?>
            <tr>
                <td><?= htmlspecialchars($purchase['purchase_id']) ?></td>
                <td><?= htmlspecialchars($purchase['purchase_date']) ?></td>
                <td><?= htmlspecialchars($purchase['total_items']) ?></td>
                <td><?= htmlspecialchars($purchase['total_quantity']) ?></td>
                <td>₹<?= number_format($purchase['total_amount'], 2) ?></td>
                <td>
                    <a href="view_purchase.php?purchase_id=<?= $purchase['purchase_id'] ?>" class="btn">View Details</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
