<?php
session_start();
require 'db.php';
include 'sidebar.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Branch Sales Receipt</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
          body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color:rgb(28, 139, 230);
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        form {
            margin-top: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
        }
    </style>
</head>
<body>
<div class="container mt-4">
    <h2 class="text-center">Branch Sales Receipt</h2>
    
    <!-- Branch Selection -->
    <div class="mb-3">
        <label class="form-label">Select Branch:</label>
        <select id="branch_name" class="form-control">
            <option value="">-- Select Branch --</option>
            <?php
            $branchQuery = "SELECT DISTINCT branch_name FROM branch_sales";
            $stmt = $pdo->prepare($branchQuery);
            $stmt->execute();
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                echo "<option value='{$row['branch_name']}'>{$row['branch_name']}</option>";
            }
            ?>
        </select>
    </div>
    
    <!-- Sale Code Selection -->
    <div class="mb-3">
        <label class="form-label">Select Branch Code:</label>
        <select id="sale_code" class="form-control" disabled>
            <option value="">-- Select Branch Code --</option>
        </select>
    </div>
    
    <!-- Receipt Details Table -->
    <div id="receiptDetails" class="mt-4" style="display:none;">
        <h5>Receipt Details</h5>
        <table>
            <thead>
                <tr>
                    <th>Book Name</th>
                    <th>Total Amount</th>
                    <th>Handover Amount</th>
                    <th>Balance Amount</th>
                </tr>
            </thead>
            <tbody id="receiptTableBody"></tbody>
        </table>
        <button id="saveReceipt" class="btn btn-success">Save Receipt</button>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#branch_name').change(function() {
        let branch_name = $(this).val();
        if (branch_name) {
            $.post('fetch_branch_sales.php', { branch_name: branch_name }, function(data) {
                $('#sale_code').html(data).prop('disabled', false);
            });
        } else {
            $('#sale_code').prop('disabled', true).html('<option value="">-- Select Sale Code --</option>');
            $('#receiptDetails').hide();
        }
    });
    
    $('#sale_code').change(function() {
        let sale_code = $(this).val();
        if (sale_code) {
            $.post('fetch_receipt_details.php', { sale_code: sale_code }, function(data) {
                $('#receiptTableBody').html(data);
                $('#receiptDetails').show();
            });
        } else {
            $('#receiptDetails').hide();
        }
    });
    
    $(document).on('input', '.handover-amount', function() {
        let total = parseFloat($(this).closest('tr').find('.total-amount').text());
        let handover = parseFloat($(this).val()) || 0;
        $(this).closest('tr').find('.balance-amount').text(total - handover);
    });
    
    $('#saveReceipt').click(function() {
        let sale_code = $('#sale_code').val();
        let receipts = [];
        $('#receiptTableBody tr').each(function() {
            let book_name = $(this).find('.book-name').text();
            let total_amount = parseFloat($(this).find('.total-amount').text());
            let handover_amount = parseFloat($(this).find('.handover-amount').val()) || 0;
            let balance_amount = total_amount - handover_amount;
            receipts.push({ book_name, total_amount, handover_amount, balance_amount });
        });
        
        $.post('save_receipt.php', { sale_code, receipts: JSON.stringify(receipts) }, function(response) {
            alert(response);
            location.reload();
        });
    });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
