<?php
// Database connection
error_reporting(E_ALL);
ini_set('display_errors', 1);

$host = 'localhost';
$db = 'bookstore_dashboard';
$user = 'bookstore_dashboard';
$pass = '9(AhSb@uHXMUk0wK';

include 'stock_update_logic.php';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// Validate required POST data
if (empty($_POST['purchase_number']) || empty($_POST['purchase_date']) || empty($_POST['supplier_id']) || empty($_POST['bill_number'])) {
    die("Error: Missing required data.");
}

// Ensure book details arrays are present and valid
if (!isset($_POST['book_id']) || !is_array($_POST['book_id']) || 
    !isset($_POST['quantity']) || !is_array($_POST['quantity']) ||
    !isset($_POST['price']) || !is_array($_POST['price']) ||
    !isset($_POST['amount']) || !is_array($_POST['amount'])) {
    die("Error: Invalid book details.");
}

// Retrieve POST values
$purchase_number = $_POST['purchase_number'];
$purchase_date = $_POST['purchase_date'];
$supplier_id = $_POST['supplier_id'];
$bill_number = $_POST['bill_number'];
$product_ids = $_POST['book_id']; // Book IDs
$quantities = $_POST['quantity'];
$prices = $_POST['price'];
$amounts = $_POST['amount'];

// Calculate total cost
$total_cost = array_sum($amounts);

try {
    // Begin transaction
    $pdo->beginTransaction();

    // Insert purchase transaction
    $stmt = $pdo->prepare("INSERT INTO purchase_transactions 
                            (purchase_number, purchase_date, supplier_id, bill_number, total_cost) 
                            VALUES (:purchase_number, :purchase_date, :supplier_id, :bill_number, :total_cost)");
    $stmt->execute([
        ':purchase_number' => $purchase_number,
        ':purchase_date' => $purchase_date,
        ':supplier_id' => $supplier_id,
        ':bill_number' => $bill_number,
        ':total_cost' => $total_cost
    ]);

    // Retrieve the last inserted ID (purchase_id)
    $purchase_id = $pdo->lastInsertId();
    if (!$purchase_id) {
        throw new Exception("Failed to retrieve the purchase_id after insert.");
    }

    // Insert book details into purchase_items and update stock
    $stmt = $pdo->prepare("INSERT INTO purchase_items (purchase_id, product_id, quantity, price, amount) 
                            VALUES (:purchase_id, :product_id, :quantity, :price, :amount)");
    for ($i = 0; $i < count($product_ids); $i++) {
        $stmt->execute([
            ':purchase_id' => $purchase_id,
            ':product_id' => $product_ids[$i], 
            ':quantity' => $quantities[$i],
            ':price' => $prices[$i],
            ':amount' => $amounts[$i]
        ]);

        // Update stock after purchase
        updateStockAfterPurchase($product_ids[$i], $quantities[$i]); // ✅ Now updates each book correctly
    }

    // Commit transaction
    $pdo->commit();
    echo "Transaction saved successfully!";
} catch (Exception $e) {
    $pdo->rollBack();
    die("Error saving transaction: " . $e->getMessage());
}
?>
