<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <style>
        /* Sidebar styles */
        .sidebar {
            width: 260px;
            height: 100vh;
            background-color: #343a40;
            padding: 20px;
            display: none;
            flex-direction: column;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1050;
        }

        .sidebar.active {
            display: flex;
        }

        .sidebar img {
            width: 100px;
            margin-bottom: 20px;
            border-radius: 54px;
        }

        .sidebar h1 {
            font-size: 20px;
            color: white;
            margin-top: -10px;
            text-align: center;
        }

        .nav-link {
            color: #f8f9fa;
            font-size: 16px;
            padding: 10px 15px;
            margin-bottom: 5px;
            border-radius: 4px;
            transition: background-color 0.3s ease;
            line-height: 1.4;
        }

        .nav-link:hover {
            background-color: #495057;
        }

        .sub-menu a {
            color: #adb5bd;
            padding-left: 30px;
            font-size: 14px;
            line-height: 1.4;
            margin-bottom: 5px;
        }

        .sub-menu a:hover {
            color: #ffffff;
        }

        .sub-menu {
            margin-top: 10px;
        }

        .nav-item {
            padding-bottom: 5px;
        }

        .nav-link i {
            margin-right: 8px;
        }

        /* Main content and button adjustment */
        .content {
            margin-left: 0;
            transition: margin-left 0.3s;
            padding: 20px;
        }

        .content.sidebar-open {
            margin-left: 260px;
        }

        .toggle-btn {
            position: fixed;
            top: 15px;
            right: 15px;
            z-index: 1055;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 50px;
            height: 50px;
        }

        .toggle-btn i {
            font-size: 18px;
        }

        .toggle-btn:hover {
            background-color: #0056b3;
        }

      .sidebar-header {
    display: flex;
    align-items: center; /* Aligns logo and text in one line */
    gap: 10px; /* Space between logo and text */
    padding: 10px;
}

.sidebar-header img {
    width: 50px;
    height: 50px;
    border-radius: 50%;
}

.tatvamasi-text {
    font-size: 18px;
    color: #cb2d13;
    font-weight: 600;
    margin: 0;
    white-space: nowrap; /* Prevents text wrapping */
}
.sidebar-header p {
    font-size: 18px;
    color: #cb2d13;
    font-weight: 600;
    margin: 0;
    white-space: nowrap; /* Prevents text wrapping */
    padding-left: 10px;
}


        .logout-btn {
            background-color: red;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
            width: 100%;
            text-align: center;
            margin-top: 20px;
        }

        .logout-btn:hover {
            background-color: darkred;
        }

        @media (max-width: 768px) {
            .toggle-btn {
                width: 40px;
                height: 40px;
                padding: 5px;
                font-size: 16px;
            }
        }
    </style>
</head>

<body>
    <!-- Sidebar -->
   <div class="sidebar-header">
    <img src="images/logo.webp" alt="Vivekananda Bookstall">
    <p class="tatvamasi-text">Tatvamasi Book Center</p>
</div>

    
    <!-- Toggle Button -->
    <button class="toggle-btn" id="toggleSidebarBtn">
        <a href="index.php"><i class="fas fa-home" style="color: white;"></i></a>
    </button>

    <!-- Bootstrap JS -->
</body>

</html>
