<?php include 'db.php'; ?>
<?php include 'sidebar.php';?>
<?php
// Calculate total stock value
$totalValueQuery = "SELECT SUM(p.mrp * p.stock) AS total_stock_value FROM product_master p 
                    JOIN category_master c ON p.category_id = c.category_id 
                    WHERE 1=1";

if (!empty($author_filter)) {
    $totalValueQuery .= " AND p.author = :author";
}
if (!empty($book_name_filter)) {
    $totalValueQuery .= " AND p.product_name LIKE :book_name";
}

$totalStmt = $pdo->prepare($totalValueQuery);
if (!empty($author_filter)) $totalStmt->bindParam(':author', $author_filter);
if (!empty($book_name_filter)) {
    $totalStmt->bindParam(':book_name', $book_name_filter);
}
$totalStmt->execute();
$totalStockValue = $totalStmt->fetchColumn();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stock Report</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
    <style>
          table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
        }
        th {
            background: #007bff;
        }
        td {
            text-align: left;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        td:nth-child(4) {
            text-align: right;
        }
        td:nth-child(5) {
            text-align: left;
        }
        td:nth-child(6) {
            text-align: left;
        }
        td:nth-child(7) {
            text-align: left;
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        .total-stock-value {
            font-size: 18px;
            font-weight: bold;
            text-align: right;
            margin-top: 10px;
        }


    </style>
    <div class="container mt-5">
        <h2 class="mb-4">Stock Report</h2>
        
        <!-- Filter Form -->
        <form method="GET" action="save_sales_return.php" class="row g-3 mb-4">
            <div class="col-md-4">
                <label for="author" class="form-label">Filter by Author</label>
                <select id="author" name="author" class="form-select">
                    <option value="">All Authors</option>
                    <?php
                    // Fetch authors from database
                    $authors = $pdo->query("SELECT DISTINCT author FROM product_master")->fetchAll();
                    foreach ($authors as $author) {
                        echo "<option value='{$author['author']}'>{$author['author']}</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="col-md-4">
                <label for="bookName" class="form-label">Filter by Book Name</label>
                <input type="text" id="bookName" name="book_name" class="form-control" placeholder="Enter book name">
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">Generate Report</button>
            </div>
        </form>

        <!-- Results Table -->
        <div>
            <h5 class="mb-3">Report Results</h5>
            <div class="total-stock-value">
                Total Stock Value: ₹ <?= number_format($totalStockValue, 2); ?>
            </div>
            <table >
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Book Name</th>
                        <th>Author</th>
                        <th>Category</th>
                        <th>MRP</th>
                        <th>Stock</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // Fetch filtered data from the database
                    $author_filter = $_GET['author'] ?? '';
                    $book_name_filter = $_GET['book_name'] ?? '';
                    
                    $query = "SELECT p.product_name, p.author, c.category_name, p.mrp, p.stock 
                              FROM product_master p 
                              JOIN category_master c ON p.category_id = c.category_id 
                              WHERE 1=1";
                    
                    // Apply filters dynamically
                    if (!empty($author_filter)) {
                        $query .= " AND p.author = :author";
                    }
                    if (!empty($book_name_filter)) {
                        $query .= " AND p.product_name LIKE :book_name";
                    }
                    
                    $stmt = $pdo->prepare($query);
                    if (!empty($author_filter)) $stmt->bindParam(':author', $author_filter);
                    if (!empty($book_name_filter)) {
                        $book_name_filter = "%$book_name_filter%";
                        $stmt->bindParam(':book_name', $book_name_filter);
                    }
                    $stmt->execute();
                    $results = $stmt->fetchAll();
                    
                    // Display results
                    if (!empty($results)) {
                        foreach ($results as $index => $row) {
                            echo "<tr>
                                <td>" . ($index + 1) . "</td>
                                <td>{$row['product_name']}</td>
                                <td>{$row['author']}</td>
                                <td>{$row['category_name']}</td>
                                <td>{$row['mrp']}</td>
                                <td>{$row['stock']}</td>
                              </tr>";
                        }
                    } else {
                        echo "<tr><td colspan='6' class='text-center'>No results found</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
