<?php
// Database Connection
include 'db.php';
 include 'sidebar.php';
// Fetch return data
try {
    $query = "SELECT * FROM returns ORDER BY return_date DESC";
    $stmt = $pdo->query($query);
    $returns = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Error fetching returns: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Returns</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background: #007bff;
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        .button-container {
            margin-bottom: 20px;
        }
        .button-container a {
            background-color: #007BFF;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            display: inline-block;
        }
        .button-container a:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <h1>View Returns</h1>

    <!-- Add Returns Button -->
    <div class="button-container">
        <a href="add_returns.php"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus-circle" viewBox="0 0 16 16">
  <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
  <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4"/>
</svg></a>
    </div>

    <!-- Returns Table -->
    <table>
        <thead>
            <tr>
                <th>Transaction ID</th>
                <th>Return Type</th>
                <th>Item ID</th>
                <th>Item Type</th>
                <th>Quantity</th>
                <th>Remarks</th>
                <th>Return Date</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($returns)): ?>
                <?php foreach ($returns as $return): ?>
                    <tr>
                        <td><?= htmlspecialchars($return['transaction_id']); ?></td>
                        <td><?= htmlspecialchars($return['return_type']); ?></td>
                        <td><?= htmlspecialchars($return['item_id']); ?></td>
                        <td><?= htmlspecialchars($return['item_type']); ?></td>
                        <td><?= htmlspecialchars($return['quantity']); ?></td>
                        <td><?= htmlspecialchars($return['remarks']); ?></td>
                        <td><?= htmlspecialchars($return['return_date']); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7">No returns found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>
