<?php
session_start();
include 'header.php';


// Database connection
$host = "localhost";
$db = "savithri";
$user = "savithri";
$pass = "LU*[nrO_70]7zsR_";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Ensure user is logged in
if (!isset($_SESSION['email'])) {
    die("You must log in first.");
}

$user_email = $_SESSION['email'];

// Fetch user's region
$user_stmt = $conn->prepare("SELECT region FROM users WHERE email = ?");
$user_stmt->bind_param("s", $user_email);
$user_stmt->execute();
$user_res = $user_stmt->get_result();

if ($user_res->num_rows === 0) {
    die("User not found.");
}

$user_data = $user_res->fetch_assoc();
$user_region = strtolower(trim($user_data['region']));

// Select price column based on region
$price_column = ($user_region === "region 2") ? "price_region" : "price";

// Fetch products with correct price column
$result = $conn->query("SELECT id, name, $price_column AS price FROM print_products WHERE category_id = 2");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Konica Minolta Products</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #f5f5f5;
      font-family: 'Segoe UI', sans-serif;
    }
    .card {
      border-radius: 15px;
    }
    .product-title {
      font-weight: 600;
      font-size: 16px;
    }
    .price-per-page {
      font-size: 14px;
      color: #888;
    }
    .total {
      font-weight: bold;
      color:#70916a;
    }
    .btn-icon {
      padding: 4px 10px;
      font-size: 16px;
    }
    .page-input {
      width: 60px;
      text-align: center;
    }
  </style>
</head>
<body>

<div class="container py-5">
  <h2 class="mb-4 text-center" style="color: #2c3169;">Konica Minolta Products</h2>
  <div class="row">
    <?php while ($row = $result->fetch_assoc()): ?>
    <div class="col-md-6 mb-4">
      <div class="card p-3 shadow-sm h-100">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <span class="product-title"><?= htmlspecialchars($row['name']) ?></span>
          <span id="total-<?= $row['id'] ?>" class="total">₹ 0.00</span>
        </div>
        <div class="d-flex justify-content-between align-items-center">
          <small class="price-per-page">₹ <?= number_format($row['price'], 2) ?> per page</small>
          <div class="d-flex align-items-center gap-2">
            <button class="btn btn-outline-dark btn-sm btn-icon" onclick="changePages(<?= $row['id'] ?>, -1)">−</button>
            <input type="number" id="pages-<?= $row['id'] ?>" value="0" readonly class="form-control form-control-sm page-input">
            <button class="btn btn-outline-dark btn-sm btn-icon" 
                    onclick="changePages(<?= $row['id'] ?>, 1)" 
                    data-price="<?= $row['price'] ?>" 
                    id="price-<?= $row['id'] ?>">+</button>
          </div>
          <button class="cart" onclick='addToCart(<?= json_encode($row) ?>)' style="border-color: white;">🛒</button>
        </div>
      </div>
    </div>
    <?php endwhile; ?>
  </div>
</div>

<script>
function changePages(id, delta) {
  const input = document.getElementById("pages-" + id);
  let pages = parseInt(input.value) || 0;
  pages = Math.max(0, pages + delta);
  input.value = pages;

  const priceBtn = document.getElementById("price-" + id);
  const price = parseFloat(priceBtn.dataset.price) || 0;
  const total = price * pages;

  const totalEl = document.getElementById("total-" + id);
  if (totalEl) totalEl.textContent = "₹ " + total.toFixed(2);
}

function addToCart(product) {
  const pages = parseInt(document.getElementById("pages-" + product.id).value) || 0;
  if (pages === 0) return alert("Please enter pages before adding.");

  const total = (pages * parseFloat(product.price)).toFixed(2);
  let cart = JSON.parse(localStorage.getItem("cart") || "[]");

  // Remove existing product if exists
  cart = cart.filter(item => !(item.productId === product.id && item.categoryId === "konica_minolta"));

  cart.push({
    categoryId: "konica_minolta",
    productId: product.id,
    name: product.name,
    price: product.price,
    pages: pages,
    total: total
  });

  localStorage.setItem("cart", JSON.stringify(cart));
  updateCartCount();
  alert("Added to cart!");
}

function updateCartCount() {
  const cart = JSON.parse(localStorage.getItem("cart") || "[]");
  const badge = document.getElementById("cart-count");
  if (badge) badge.textContent = cart.length;
}
updateCartCount();
</script>

</body>
</html>
