<?php
session_start();
header('Content-Type: application/json');

$DB_HOST = 'localhost';
$DB_USER = 'savithri';
$DB_PASS = 'LU*[nrO_70]7zsR_';
$DB_NAME = 'savithri';

$conn = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

// Ensure user is logged in
if (!isset($_SESSION['email'])) {
    echo json_encode(['success' => false, 'error' => 'User not logged in']);
    exit;
}

$user_email = $_SESSION['email'];

// 🟢 Check if table `cart` exists (important for custom setups)
$check_table = $conn->query("SHOW TABLES LIKE 'cart'");
if ($check_table->num_rows === 0) {
    echo json_encode(['success' => false, 'error' => 'Cart table missing']);
    exit;
}

// 🟢 Count items for this user
$stmt = $conn->prepare("SELECT SUM(quantity) AS total_items FROM cart WHERE user_email = ?");
$stmt->bind_param("s", $user_email);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

$cart_count = (int)($row['total_items'] ?? 0);

echo json_encode([
    'success' => true,
    'cart_count' => $cart_count
]);

$stmt->close();
$conn->close();
?>
