<?php
session_start();
include 'header.php';

// Database connection
$host = "localhost";
$db = "savithri";
$user = "savithri";
$pass = "LU*[nrO_70]7zsR_";
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Ensure user is logged in
if (!isset($_SESSION['email'])) {
    die("You must log in first.");
}

$user_email = $_SESSION['email'];

// Fetch user's region
$user_stmt = $conn->prepare("SELECT region FROM users WHERE email = ?");
$user_stmt->bind_param("s", $user_email);
$user_stmt->execute();
$user_res = $user_stmt->get_result();

if ($user_res->num_rows === 0) {
    die("User not found.");
}

$user_data = $user_res->fetch_assoc();
$user_region = strtolower(trim($user_data['region']));

// Select price column based on region
$price_column = ($user_region === "region 2") ? "price_region" : "price";

// Fetch products
$result = $conn->query("SELECT id, name, $price_column AS price FROM print_products WHERE category_id = 2");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Konica Minolta Products</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body {
  background: #f5f5f5;
  font-family: 'Segoe UI', sans-serif;
  margin-bottom: 80px;
}
.card {
  border-radius: 15px;
  transition: 0.3s;
}
.card:hover {
  transform: translateY(-3px);
  box-shadow: 0 4px 10px rgba(0,0,0,0.1);
}
.product-title {
  font-weight: 600;
  font-size: 16px;
  color: #2c3169;
}
.price-per-page {
  font-size: 14px;
  color: #777;
}
.total {
  font-weight: bold;
  color: #70916a;
}
.page-input {
  width: 60px;
  text-align: center;
}
.footer-summary {
  position: fixed;
  bottom: 0;
  width: 100%;
  background: #fff;
  border-top: 1px solid #ccc;
  padding: 10px 15px;
  font-size: 14px;
  color: #333;
  box-shadow: 0 -1px 5px rgba(0,0,0,0.1);
  display: flex;
  justify-content: space-between;
  align-items: center;
  z-index: 1050;
}
@media (max-width: 576px) {
  .footer-summary {
    flex-direction: column;
    gap: 8px;
    text-align: center;
  }
}
</style>
</head>
<body>

<div class="container py-5">
  <h2 class="mb-4 text-center" style="color:#2c3169;">Konica Minolta Products</h2>
  <div class="row">
    <?php while ($row = $result->fetch_assoc()): ?>
    <div class="col-md-6 mb-4">
      <div class="card p-3 shadow-sm h-100">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <span class="product-title" id="title-<?= $row['id'] ?>"><?= htmlspecialchars($row['name']) ?></span>
          <span id="total-<?= $row['id'] ?>" class="total">₹ 0.00</span>
        </div>
        <div class="d-flex justify-content-between align-items-center">
          <small class="price-per-page">₹ <?= number_format($row['price'], 2) ?> per page</small>
          <div class="d-flex align-items-center gap-2">
            <button class="btn btn-outline-dark btn-sm" onclick="changePages(<?= $row['id'] ?>, -1, <?= $row['price'] ?>)">−</button>
            <input type="number" id="pages-<?= $row['id'] ?>" value="0" readonly class="form-control form-control-sm page-input">
            <button class="btn btn-outline-dark btn-sm" onclick="changePages(<?= $row['id'] ?>, 1, <?= $row['price'] ?>)">+</button>
          </div>
        </div>
      </div>
    </div>
    <?php endwhile; ?>
  </div>
</div>

<!-- Footer summary -->
<div class="footer-summary" id="footer-summary">
  <div id="page-summary-text">No selection</div>
  <button class="btn btn-primary btn-sm" onclick="submitSelection()">Submit</button>
</div>

<script>
let pageSummary = {};

function changePages(id, delta, price) {
  const input = document.getElementById("pages-" + id);
  let pages = parseInt(input.value) || 0;
  pages = Math.max(0, pages + delta);
  input.value = pages;

  const total = price * pages;
  document.getElementById("total-" + id).textContent = "₹ " + total.toFixed(2);

  const name = document.getElementById("title-" + id).textContent;
  if (pages > 0) {
    pageSummary[id] = { id, name, pages, price };
  } else {
    delete pageSummary[id];
  }
  updateFooterSummary();
}

function updateFooterSummary() {
  const footerText = document.getElementById("page-summary-text");
  const items = Object.values(pageSummary);
  const summaries = items.map(item => `${item.pages} page(s)`);
  const totalAmount = items.reduce((sum, item) => sum + item.pages * item.price, 0);

  footerText.innerHTML = items.length
    ? `Selected → ${summaries.join(' | ')} | <strong style="color:#70916a;">Total: ₹ ${totalAmount.toFixed(2)}</strong>`
    : 'No selection';
}

async function submitSelection() {
  if (!Object.keys(pageSummary).length) {
    alert('Please select at least one product.');
    return;
  }

  try {
    for (const item of Object.values(pageSummary)) {
      const response = await fetch('update_cart.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
          action: 'add',
          product_id: item.id,
          product_type: 'print',
          quantity: item.pages
        })
      });

      const result = await response.json();
      if (!result.success) throw new Error(result.error || 'Failed to add to cart');

      const cartCount = document.getElementById('cartCount');
      if (cartCount) {
        cartCount.textContent = result.cart_count || '0';
        cartCount.style.display = 'inline-block';
      }
    }

    showToast('Products added to cart!', 'success');
    Object.keys(pageSummary).forEach(id => {
      document.getElementById(`pages-${id}`).value = '0';
      document.getElementById(`total-${id}`).textContent = '₹ 0.00';
    });
    pageSummary = {};
    updateFooterSummary();

  } catch (error) {
    console.error('Error:', error);
    showToast('Error: ' + error.message, 'danger');
  }
}

function showToast(message, type = 'success') {
  const toast = document.createElement('div');
  toast.className = `toast align-items-center text-white bg-${type} border-0 show`;
  toast.innerHTML = `
    <div class="d-flex">
      <div class="toast-body">${message}</div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
    </div>`;
  const container = document.createElement('div');
  container.className = 'toast-container position-fixed bottom-0 end-0 p-3';
  container.style.zIndex = '1100';
  container.appendChild(toast);
  document.body.appendChild(container);
  setTimeout(() => container.remove(), 3000);
}
</script>
</body>
</html>
