<?php 
include 'includes/auth.php'; 
include 'includes/header.php'; 

$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

// Pagination settings
$limit = 10; // products per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$offset = ($page - 1) * $limit;

// Count total products
$totalResult = $conn->query("SELECT COUNT(*) AS total FROM products");
$totalRow = $totalResult->fetch_assoc();
$totalProducts = $totalRow['total'];
$totalPages = ceil($totalProducts / $limit);

// Fetch products with pagination
$sql = "SELECT p.*, pk.name AS package_name 
        FROM products p 
        LEFT JOIN packages pk ON p.package_id = pk.id 
        ORDER BY p.id DESC 
        LIMIT $limit OFFSET $offset";
$products = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>View Products</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body {
      background: #f9f9f9;
      font-family: 'Segoe UI', sans-serif;
    }
    h2 {
      font-weight: 600;
      margin: 30px 0;
      text-align: center;
    }
    .table-wrapper {
      background: #fff;
      border-radius: 15px;
      padding: 25px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.08);
    }
    .btn-sm {
      padding: 3px 10px;
      font-size: 0.85rem;
    }
  </style>
</head>
<body>

<div class="container py-5">
  <h2>📦 All Products</h2>
  <div class="table-wrapper">
    <table class="table table-bordered table-hover align-middle">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Product Name</th>
          <th>Package</th>
          <th>Region1</th>
          <th>Region2</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php if ($products->num_rows > 0): ?>
          <?php $i=$offset+1; while($row = $products->fetch_assoc()): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= htmlspecialchars($row['name']) ?></td>
              <td><?= htmlspecialchars($row['package_name'] ?? '-') ?></td>
              <td><?= number_format($row['mrp'], 2) ?></td>
              <td><?= htmlspecialchars($row['mrp_region'] ?? '-') ?></td>
              <td>
                <!-- Edit Button (skyblue / primary) -->
                <a href="edit_product.php?id=<?= $row['id'] ?>" class="btn btn-primary btn-sm">Edit</a>

                <!-- Disable Button -->
                <a href="disable_product.php?id=<?= $row['id'] ?>" 
                   class="btn btn-danger btn-sm" 
                   onclick="return confirm('Are you sure you want to disable this product?')">
                   Disable
                </a>
              </td>
            </tr>
          <?php endwhile; ?>
        <?php else: ?>
          <tr>
            <td colspan="6" class="text-center">No products found</td>
          </tr>
        <?php endif; ?>
      </tbody>
    </table>

    <!-- Pagination -->
    <?php if ($totalPages > 1): ?>
      <nav>
        <ul class="pagination justify-content-center">
          <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
            <a class="page-link" href="?page=<?= $page-1 ?>">Previous</a>
          </li>
          <?php for ($i=1; $i<=$totalPages; $i++): ?>
            <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
              <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
            </li>
          <?php endfor; ?>
          <li class="page-item <?= ($page >= $totalPages) ? 'disabled' : '' ?>">
            <a class="page-link" href="?page=<?= $page+1 ?>">Next</a>
          </li>
        </ul>
      </nav>
    <?php endif; ?>
  </div>
</div>

</body>
</html>
