<?php
// Start session and enable error reporting at the very top
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include header
$root = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . '/savithridigital/';
if (file_exists($root . 'header.php')) {
    include $root . 'header.php';
} else {
    // Fallback header if header.php is not found
    echo '<!DOCTYPE html><html><head><title>Cart - Savithri Digital</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .cart-container { max-width: 1200px; margin: 30px auto; padding: 20px; }
        .cart-item { background: white; border-radius: 10px; padding: 20px; margin-bottom: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); }
        .product-image { width: 100px; height: 100px; object-fit: cover; border-radius: 8px; }
        .quantity-input { width: 60px; text-align: center; }
        .empty-cart { text-align: center; padding: 50px 20px; }
        .empty-cart i { font-size: 50px; color: #ddd; margin-bottom: 20px; }
    </style>
    </head><body>';
}

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$user_id = $_SESSION['user_id'] ?? 0;
if (!$user_id) {
    echo "<div class='empty-cart'><p>Please log in to view your cart.</p></div>";
    if (file_exists($root . 'footer.php')) {
        include $root . 'footer.php';
    } else {
        echo '</body></html>';
    }
    exit;
}

// Update the query in cart.php to use the correct column names
// ... (keep your existing header and database connection code) ...

$query = "
    SELECT 
        c.id as cart_id, 
        c.quantity, 
        c.product_id, 
        c.product_type,
        COALESCE(p.name, pp.name) as name,
        CASE 
            WHEN c.product_type = 'print' THEN 
                CASE 
                    WHEN ? = 'region2' THEN pp.price_region 
                    ELSE pp.price 
                END
            WHEN c.product_type = 'regular' THEN p.mrp 
            ELSE 0 
        END as price,
        COALESCE(p.image, '') as image,
        pkg.name as package_name
    FROM cart c
    LEFT JOIN products p ON (c.product_id = p.id AND c.product_type = 'regular')
    LEFT JOIN print_products pp ON (c.product_id = pp.id AND c.product_type = 'print')
    LEFT JOIN packages pkg ON p.package_id = pkg.id
    WHERE c.user_id = ?
    ORDER BY c.created_at DESC
";

// Prepare and execute the statement with parameters
$stmt = $conn->prepare($query);
if ($stmt === false) {
    die("Prepare failed: " . $conn->error);
}

$region = ($_SESSION['user_region'] ?? 'Region 1') === 'Region 2' ? 'region2' : 'region1';
$stmt->bind_param('si', $region, $user_id);

if (!$stmt->execute()) {
    die("Execute failed: " . $stmt->error);
}

$result = $stmt->get_result();
$cart_items = $result->fetch_all(MYSQLI_ASSOC);

// Calculate subtotal
$subtotal = 0;
foreach ($cart_items as $item) {
    $subtotal += $item['price'] * $item['quantity'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Cart - Savithri Digital</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
   <!-- In your HTML head section -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script>
    window.jsPDF = window.jspdf.jsPDF;
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.25/jspdf.plugin.autotable.min.js"></script>
    <style>
        .cart-container {
            max-width: 1200px;
            margin: 30px auto;
            padding: 20px;
        }
        .cart-item {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .product-image {
            width: 100px;
            height: 100px;
            object-fit: cover;
            border-radius: 8px;
        }
        .quantity-input {
            width: 60px;
            text-align: center;
        }
        .empty-cart {
            text-align: center;
            padding: 50px 20px;
        }
        .empty-cart i {
            font-size: 50px;
            color: #ddd;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="cart-container">
        <h2 class="mb-4">Your Shopping Cart</h2>
        
       <?php if (empty($cart_items)): ?>
        <div class="empty-cart">
            <i class="fas fa-shopping-cart"></i>
            <h3>Your cart is empty</h3>
            <p>Looks like you haven't added anything to your cart yet.</p>
            <a href="products.php" class="btn btn-primary">Continue Shopping</a>
        </div>
    <?php else: ?>
        <div class="row">
            <div class="col-lg-8">
                <?php foreach ($cart_items as $item): 
                    $item_total = $item['price'] * $item['quantity'];
                ?>
                    <div class="cart-item">
                        <div class="row align-items-center">
                            <div class="col-md-2">
                                <?php if (!empty($item['image'])): ?>
                                    <img src="uploads/<?= htmlspecialchars($item['image']) ?>" 
                                         alt="<?= htmlspecialchars($item['name']) ?>" 
                                         class="product-image">
                                <?php else: ?>
                                    <div class="bg-light d-flex align-items-center justify-content-center" 
                                         style="width: 100px; height: 100px; border-radius: 8px;">
                                        <i class="fas fa-image text-muted"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-4">
                                <h5 class="mb-1">
                                    <?= htmlspecialchars($item['name']) ?>
                                    <?php if (!empty($item['package_name'])): ?>
                                        <small class="text-muted">(<?= htmlspecialchars($item['package_name']) ?>)</small>
                                    <?php endif; ?>
                                    <br>
                                    <small class="text-muted">Type: <?= htmlspecialchars($item['product_type']) ?></small>
                                </h5>
                                <p class="text-muted mb-2">₹<?= number_format($item['price'], 2) ?></p>
                                <form method="post" action="remove_from_cart.php" style="display: inline;">
                                    <input type="hidden" name="cart_id" value="<?= $item['cart_id'] ?>">
                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                        <i class="fas fa-trash"></i> Remove
                                    </button>
                                </form>
                            </div>
                            <div class="col-md-3">
                                <form method="post" action="update_cart.php" class="d-flex align-items-center">
                                    <input type="hidden" name="cart_id" value="<?= $item['cart_id'] ?>">
                                    <button type="button" class="btn btn-sm btn-outline-secondary quantity-decrease">-</button>
                                    <input type="number" name="quantity" value="<?= $item['quantity'] ?>" 
                                           min="1" class="form-control mx-2 quantity-input" 
                                           onchange="this.form.submit()">
                                    <button type="button" class="btn btn-sm btn-outline-secondary quantity-increase">+</button>
                                </form>
                            </div>
                            <div class="col-md-3 text-end">
                                <strong>₹<?= number_format($item_total, 2) ?></strong>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Order Summary</h5>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Subtotal (<?= count($cart_items) ?> items)</span>
                            <span>₹<?= number_format($subtotal, 2) ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-3">
                            <strong>Total</strong>
                            <strong>₹<?= number_format($subtotal, 2) ?></strong>
                        </div>
                        <a href="checkout.php" class="btn btn-primary w-100">Proceed to Checkout</a>
                       <button id="downloadCartPdf" class="btn btn-success w-100 mt-2">
    <i class="fas fa-download me-2"></i>Download PDF
</button>

                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Quantity controls
document.querySelectorAll('.quantity-increase').forEach(button => {
    button.addEventListener('click', function() {
        const input = this.previousElementSibling;
        input.stepUp();
        input.dispatchEvent(new Event('change'));
    });
});

document.querySelectorAll('.quantity-decrease').forEach(button => {
    button.addEventListener('click', function() {
        const input = this.nextElementSibling;
        if (input.value > 1) {
            input.stepDown();
            input.dispatchEvent(new Event('change'));
        }
    });
});

// PDF Download
document.addEventListener('DOMContentLoaded', function() {
    const downloadBtn = document.getElementById('downloadCartPdf');
    
    if (downloadBtn) {
        downloadBtn.addEventListener('click', function() {
            try {
                const doc = new jsPDF();

                // Title
                doc.setFontSize(18);
                doc.text('Savithri Digital - Order Receipt', 14, 22);
                doc.setFontSize(11);
                doc.text(`Date: ${new Date().toLocaleDateString()}`, 14, 30);

                // Table
                const tableColumn = ['#', 'Product', 'Qty', 'Price', 'Total'];
                const tableRows = [];
                let subtotal = 0;

                document.querySelectorAll('.cart-item').forEach((item, index) => {
                    const name = item.querySelector('.mb-1').textContent.trim().split('\n')[0].trim();

                    // Get and clean price text safely
                    let priceText = item.querySelector('.text-muted.mb-2').textContent
                        .replace(/Rs\.?/gi, '')   // remove Rs or Rs.
                        .replace(/₹/g, '')        // remove rupee symbol if any
                        .replace(/[^\d.]/g, '')   // keep only numbers and dot
                        .trim();

                    const price = parseFloat(priceText) || 0;
                    const quantity = parseInt(item.querySelector('.quantity-input').value) || 0;
                    const total = price * quantity;
                    subtotal += total;

                    tableRows.push([
                        index + 1,
                        name,
                        quantity,
                        'Rs.' + price.toFixed(2),
                        'Rs.' + total.toFixed(2)
                    ]);
                });

                doc.autoTable({
                    head: [tableColumn],
                    body: tableRows,
                    startY: 40,
                    headStyles: {
                        fillColor: [41, 128, 185],
                        textColor: 255,
                        fontStyle: 'bold'
                    },
                    columnStyles: {
                        0: { cellWidth: 10 },
                        1: { cellWidth: 100 },
                        2: { cellWidth: 20 },
                        3: { cellWidth: 30 },
                        4: { cellWidth: 30 }
                    }
                });

                const finalY = doc.lastAutoTable.finalY + 15;
                doc.setFontSize(12);
                doc.setFont(undefined, 'bold');
                doc.text('Subtotal:', 140, finalY);
                doc.text('Rs.' + subtotal.toFixed(2), 170, finalY);

                doc.save('order-receipt.pdf');
            } catch (error) {
                console.error('Error generating PDF:', error);
                alert('Error generating PDF: ' + error.message);
            }
        });
    }
});
</script>



</body>
</html>

<?php
$conn->close();
?>