<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json');

// Debug: Log the incoming request
file_put_contents('cart_debug.log', date('Y-m-d H:i:s') . " - Request: " . file_get_contents('php://input') . "\n", FILE_APPEND);

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'error' => 'Not logged in']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$action = $input['action'] ?? '';
$product_id = intval($input['product_id'] ?? 0);
$quantity = intval($input['quantity'] ?? 1);
$product_type = $input['product_type'] ?? 'print'; // Default to 'print' for hp_indigo.php

$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

$user_id = $_SESSION['user_id'];
$response = ['success' => false];

try {
    $conn->begin_transaction();

    // ... (keep the beginning of your file the same until the switch statement)

    switch ($action) {
        case 'add':
            // Check if product exists
            $table = ($product_type === 'print') ? 'print_products' : 'products';
            $product_query = $conn->prepare("SELECT id FROM $table WHERE id = ?");
            $product_query->bind_param('i', $product_id);
            $product_query->execute();
            
            if (!$product_query->get_result()->fetch_assoc()) {
                throw new Exception('Product not found');
            }

            // Check if already in cart
            $check = $conn->prepare("SELECT id, quantity FROM cart 
                                   WHERE user_id = ? AND product_id = ? AND product_type = ?");
            $check->bind_param('iis', $user_id, $product_id, $product_type);
            $check->execute();
            $existing = $check->get_result()->fetch_assoc();

            if ($existing) {
                // Update quantity if item already exists
                $new_quantity = $existing['quantity'] + $quantity;
                $update = $conn->prepare("UPDATE cart SET quantity = ? WHERE id = ?");
                $update->bind_param('ii', $new_quantity, $existing['id']);
                if (!$update->execute()) {
                    throw new Exception('Failed to update cart item');
                }
            } else {
                // Add new item with ON DUPLICATE KEY UPDATE
                $insert = $conn->prepare("INSERT INTO cart (user_id, product_id, product_type, quantity) 
                                        VALUES (?, ?, ?, ?)
                                        ON DUPLICATE KEY UPDATE 
                                        quantity = quantity + VALUES(quantity)");
                $insert->bind_param('iisi', $user_id, $product_id, $product_type, $quantity);
                if (!$insert->execute()) {
                    throw new Exception('Failed to add item to cart');
                }
            }
            break;
    }

// ... (keep the rest of your file the same)

    // Get updated cart count
    $count_query = $conn->query("SELECT COUNT(*) as count FROM cart WHERE user_id = $user_id");
    $cart_count = $count_query->fetch_assoc()['count'];

    $conn->commit();
    
    $response = [
        'success' => true,
        'cart_count' => $cart_count
    ];

} catch (Exception $e) {
    $conn->rollback();
    $response = [
        'success' => false,
        'error' => $e->getMessage()
    ];
}

// Debug: Log the response
file_put_contents('cart_debug.log', date('Y-m-d H:i:s') . " - Response: " . json_encode($response) . "\n", FILE_APPEND);

echo json_encode($response);
$conn->close();