<?php include 'header.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Choose Print Type - Savithri Digital</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    :root {
      --primary: #6c5ce7;
      --secondary: #00cec9;
      --accent: #fd79a8;
      --dark: #2d3436;
      --light: #f8f9fa;
    }
    
    body {
      background: linear-gradient(135deg, #f5f7fa 0%, #e4e8eb 100%);
      min-height: 100vh;
      font-family: 'Poppins', sans-serif;
      padding-bottom: 60px;
    }
    
    .print-choice-container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 80px 20px;
      position: relative;
      overflow: hidden;
    }
    
    .print-title {
      font-size: 2.8rem;
      font-weight: 800;
      margin-bottom: 60px;
      color: var(--dark);
      position: relative;
      display: inline-block;
      text-align: center;
      width: 100%;
    }
    
    .print-title::after {
      content: '';
      position: absolute;
      bottom: -15px;
      left: 50%;
      transform: translateX(-50%);
      width: 80px;
      height: 4px;
      background: linear-gradient(90deg, var(--primary), var(--secondary));
      border-radius: 2px;
    }
    
    .card-option {
      border: none;
      border-radius: 20px;
      transition: all 0.5s cubic-bezier(0.25, 0.8, 0.25, 1);
      cursor: pointer;
      overflow: hidden;
      position: relative;
      background: white;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
      height: 100%;
      display: flex;
      flex-direction: column;
      transform: translateY(0);
    }
    
    .card-option::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 5px;
      background: linear-gradient(90deg, var(--primary), var(--secondary));
      transition: height 0.3s ease;
    }
    
    .card-option.hp::before {
      background: linear-gradient(90deg, #6c5ce7, #a29bfe);
    }
    
    .card-option.konica::before {
      background: linear-gradient(90deg, #00cec9, #81ecec);
    }
    
    .card-option:hover {
      transform: translateY(-10px);
      box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    }
    
    .card-option:hover::before {
      height: 8px;
    }
    
    .card-body {
      padding: 40px 30px;
      display: flex;
      flex-direction: column;
      align-items: center;
      text-align: center;
      flex: 1;
    }
    
    .print-icon {
      width: 100px;
      height: 100px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 25px;
      font-size: 3rem;
      color: white;
      position: relative;
      z-index: 1;
      transition: all 0.5s ease;
    }
    
    .print-icon::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      border-radius: 50%;
      z-index: -1;
      opacity: 0.9;
      transition: all 0.5s ease;
    }
    
    .hp .print-icon::before {
      background: linear-gradient(135deg, #6c5ce7, #a29bfe);
      box-shadow: 0 10px 25px rgba(108, 92, 231, 0.4);
    }
    
    .konica .print-icon::before {
      background: linear-gradient(135deg, #00cec9, #81ecec);
      box-shadow: 0 10px 25px rgba(0, 206, 201, 0.4);
    }
    
    .card-option:hover .print-icon {
      transform: scale(1.1) rotate(5deg);
    }
    
    .card-option h4 {
      font-weight: 700;
      margin-bottom: 15px;
      color: var(--dark);
      position: relative;
      padding-bottom: 10px;
    }
    
    .card-option h4::after {
      content: '';
      position: absolute;
      bottom: 0;
      left: 50%;
      transform: translateX(-50%);
      width: 40px;
      height: 3px;
      background: var(--primary);
      border-radius: 3px;
    }
    
    .hp h4::after {
      background: linear-gradient(90deg, #6c5ce7, #a29bfe);
    }
    
    .konica h4::after {
      background: linear-gradient(90deg, #00cec9, #81ecec);
    }
    
    .print-desc {
      color: #666;
      margin-bottom: 25px;
      line-height: 1.7;
      font-size: 1rem;
      flex: 1;
    }
    
    .btn-explore {
      padding: 12px 35px;
      border-radius: 50px;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 1px;
      font-size: 0.85rem;
      transition: all 0.3s ease;
      border: none;
      position: relative;
      overflow: hidden;
      z-index: 1;
    }
    
    .btn-explore::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      z-index: -1;
      border-radius: 50px;
      transition: all 0.3s ease;
    }
    
    .hp .btn-explore {
      color: white;
      background: linear-gradient(90deg, #6c5ce7, #a29bfe);
      box-shadow: 0 5px 15px rgba(108, 92, 231, 0.4);
    }
    
    .konica .btn-explore {
      color: white;
      background: linear-gradient(90deg, #00cec9, #81ecec);
      box-shadow: 0 5px 15px rgba(0, 206, 201, 0.4);
    }
    
    .btn-explore:hover {
      transform: translateY(-3px);
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
    }
    
    .hp .btn-explore:hover {
      box-shadow: 0 8px 25px rgba(108, 92, 231, 0.6);
    }
    
    .konica .btn-explore:hover {
      box-shadow: 0 8px 25px rgba(0, 206, 201, 0.6);
    }
    
    .btn-explore:active {
      transform: translateY(-1px);
    }
    
    /* Floating Elements */
    .floating-shape {
      position: absolute;
      border-radius: 50%;
      opacity: 0.1;
      z-index: -1;
      animation: float 15s infinite ease-in-out;
    }
    
    .shape-1 {
      width: 200px;
      height: 200px;
      top: 10%;
      left: 5%;
      background: var(--primary);
      animation-delay: 0s;
    }
    
    .shape-2 {
      width: 300px;
      height: 300px;
      bottom: 10%;
      right: 5%;
      background: var(--secondary);
      animation-delay: 3s;
      animation-duration: 20s;
    }
    
    @keyframes float {
      0%, 100% { transform: translateY(0) rotate(0deg); }
      50% { transform: translateY(-20px) rotate(5deg); }
    }
    
    /* Responsive Styles */
    @media (max-width: 768px) {
      .print-choice-container {
        padding: 60px 15px;
      }
      
      .print-title {
        font-size: 2.2rem;
        margin-bottom: 40px;
      }
      
      .card-body {
        padding: 30px 20px;
      }
      
      .print-icon {
        width: 80px;
        height: 80px;
        font-size: 2.5rem;
      }
    }
    
    @media (max-width: 576px) {
      .print-title {
        font-size: 1.8rem;
      }
      
      .card-option {
        margin-bottom: 30px;
      }
    }
  </style>
</head>
<body>
  <div class="print-choice-container">
    <!-- Floating Shapes -->
    <div class="floating-shape shape-1"></div>
    <div class="floating-shape shape-2"></div>
    
    <h1 class="print-title animate__animated animate__fadeInDown">Choose Your Print Type</h1>
    
    <div class="row g-4 justify-content-center">
      <!-- HP Indigo Card -->
      <div class="col-lg-5 col-md-6">
        <div class="card-option hp animate__animated animate__fadeInLeft">
          <div class="card-body">
            <div class="print-icon">
              <i class="fas fa-print"></i>
            </div>
            <h4>HP Indigo</h4>
            <p class="print-desc">Experience unparalleled print quality with our HP Indigo digital presses, delivering vibrant colors, sharp details, and professional-grade results for all your printing needs.</p>
            <a href="hpindigo.php" class="btn btn-explore">Explore HP Indigo</a>
          </div>
        </div>
      </div>
      
      <!-- Konica Minolta Card -->
      <div class="col-lg-5 col-md-6">
        <div class="card-option konica animate__animated animate__fadeInRight">
          <div class="card-body">
            <div class="print-icon">
              <i class="fas fa-print"></i>
            </div>
            <h4>Konica Minolta</h4>
            <p class="print-desc">High-speed, high-quality digital printing solutions perfect for both small and large volume projects, offering exceptional value and consistent results.</p>
            <a href="konica.php" class="btn btn-explore">Explore Konica Minolta</a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Add hover effect to cards
    document.querySelectorAll('.card-option').forEach(card => {
      card.addEventListener('mouseenter', function() {
        this.style.transform = 'translateY(-15px)';
      });
      
      card.addEventListener('mouseleave', function() {
        this.style.transform = 'translateY(-10px)';
      });
    });
    
    // Add animation on scroll
    document.addEventListener('DOMContentLoaded', function() {
      const cards = document.querySelectorAll('.card-option');
      
      const observerOptions = {
        threshold: 0.2,
        rootMargin: '0px 0px -50px 0px'
      };
      
      const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            entry.target.classList.add('animate__animated', 'animate__fadeInUp');
            observer.unobserve(entry.target);
          }
        });
      }, observerOptions);
      
      cards.forEach(card => {
        observer.observe(card);
      });
    });
  </script>
</body>
</html>
<?php include 'footer.php'; ?>