<?php
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $company_name   = trim($_POST['company_name']);
    $billing_address = trim($_POST['billing_address']);
    $gst_no         = trim($_POST['gst_no']);
    $name           = trim($_POST['name']);
    $mobile         = trim($_POST['mobile']);
    $email          = trim($_POST['email']);
    $address        = trim($_POST['address']);
    $zip_code       = trim($_POST['zip_code']);
    $state          = trim($_POST['state']);

    // Check if email exists
    $check_sql = "SELECT * FROM users WHERE email = ?";
    $stmt = $conn->prepare($check_sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        echo "<script>alert('This email is already registered.'); window.location='register.php';</script>";
    } else {
        $sql = "INSERT INTO users (company_name, billing_address, gst_no, name, mobile, email, address, zip_code, state)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssssssss", $company_name, $billing_address, $gst_no, $name, $mobile, $email, $address, $zip_code, $state);
        if ($stmt->execute()) {
            echo "<script>alert('Registration successful! Admin will create your username soon.'); window.location='index.php';</script>";
        } else {
            echo "<script>alert('Error: " . $stmt->error . "');</script>";
        }
    }
    $stmt->close();
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>User Registration | Savithri Digital Print Press</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" href="https://test.kalpavrukshaits.com/savithridigital/images/logo.jpeg" type="image/png">
    <!-- Bootstrap 5 CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Bootstrap Icons -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <style>
        .header {
  transition: all 0.3s ease-in-out;
}

.header img {
  filter: drop-shadow(0 0 2px rgba(0,0,0,0.1));
}

.header .btn {
  font-size: 15px;
  box-shadow: 0 4px 10px rgba(47, 42, 133, 0.15);
  transition: all 0.3s ease;
}

.header .btn:hover {
  transform: translateY(-2px);
}

    </style>
</head>
<body>

<!-- Header Section (Same as index.php) -->
<header class="bg-white shadow-sm py-3 px-4 sticky-top">
  <div class="container d-flex align-items-center justify-content-between flex-wrap">
    <!-- Logo + Tagline -->
    <div class="d-flex align-items-center mb-2 mb-md-0">
      <img src="https://test.kalpavrukshaits.com/savithridigital/images/logo.jpeg" 
           alt="Savithri Logo" 
           style="height: 45px; margin-right: 10px;">
      <div>
        <h4 class="m-0 fw-bold" style="color: #2f2a85;">Savithri</h4>
        <p class="m-0" style="font-size: 13px; line-height: 1;">
          DIGITAL PRINT PRESS (P) LTD<br>
          <span style="font-size: 11px; color: #444;">(a unit of savithri photo house)</span>
        </p>
        <p class="m-0 mt-1 fw-semibold" style="font-style: italic; color: #2f2a85;">
          We Exceed Your Expectations
        </p>
      </div>
    </div>

    <!-- Login & Register Buttons -->
    <div class="d-flex gap-2">
      <a href="https://test.kalpavrukshaits.com/savithridigital/admin/signin.php" 
         class="btn btn-outline-primary rounded-pill px-4 fw-semibold d-flex align-items-center" 
         style="border-color: #2f2a85; color: #2f2a85;">
        <i class="bi bi-box-arrow-in-right me-2"></i> Login
      </a>
      <a href="register.php" 
         class="btn rounded-pill px-4 fw-semibold text-white d-flex align-items-center" 
         style="background-color: #2f2a85;">
        <i class="bi bi-person-plus-fill me-2"></i> Register
      </a>
    </div>
  </div>
</header>


<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-7 col-lg-6">
            <div class="card shadow p-4">
                <h3 class="text-center mb-4 fw-bold" style="color: var(--main-color);">User Registration</h3>

                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label">Company Name</label>
                        <input type="text" name="company_name" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Billing Address</label>
                        <textarea name="billing_address" class="form-control" rows="2" required></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">GST Number</label>
                        <input type="text" name="gst_no" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Mobile Number</label>
                        <input type="text" name="mobile" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Address</label>
                        <textarea name="address" class="form-control" rows="2" required></textarea>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Zip Code</label>
                            <input type="text" name="zip_code" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">State</label>
                            <input type="text" name="state" class="form-control" required>
                        </div>
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn-submit">Register</button>
                    </div>
                </form>

                <div class="mt-3 text-center">
                    <a href="index.php" class="text-decoration-none fw-semibold" style="color: var(--main-color);">← Back to Home</a>
                </div>
            </div>
        </div>
    </div>
</div>

</body>
</html>
