<?php
include 'includes/header.php';
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

// Sanitize input
$order_number = $_GET['order_number'] ?? '';
if (!$order_number) {
  echo "<div class='container mt-5'><div class='alert alert-danger'>Order number is missing.</div></div>";
  exit;
}

// Fetch order info
$order = $conn->query("SELECT * FROM orders WHERE order_number = '$order_number'")->fetch_assoc();
if (!$order) {
  echo "<div class='container mt-5'><div class='alert alert-warning'>Order not found.</div></div>";
  exit;
}

// Fetch order items
$order_items = $conn->query("SELECT * FROM order_items WHERE order_id = {$order['id']}");
?>

<div class="container mt-5">
  <h3>🧾 Order Details</h3>
  <p><strong>Order No:</strong> <?= $order['order_number'] ?></p>
  <p><strong>User Name:</strong> <?= htmlspecialchars($order['user_name'] ?? 'N/A') ?></p>
  <p><strong>Date:</strong> <?= $order['created_at'] ?></p>
  <p><strong>Status:</strong> 
    <span class="badge bg-<?= $order['status'] === 'Completed' ? 'success' : 'warning' ?>">
      <?= $order['status'] ?>
    </span>
  </p>

  <table class="table table-bordered mt-4">
    <thead class="table-light">
      <tr>
        <th>#</th>
        <th>Product</th>
        <th>Pages</th>
        <th>Price</th>
        <th>Total</th>
      </tr>
    </thead>
    <tbody>
      <?php 
      $i = 1; 
      $grand_total = 0;
      while ($item = $order_items->fetch_assoc()):
        $grand_total += $item['total'];
      ?>
        <tr>
          <td><?= $i++ ?></td>
          <td><?= htmlspecialchars($item['name']) ?></td>
          <td><?= $item['pages'] ?? '-' ?></td>
          <td>₹<?= number_format($item['price'], 2) ?></td>
          <td>₹<?= number_format($item['total'], 2) ?></td>
        </tr>
      <?php endwhile; ?>
    </tbody>
    <tfoot>
      <tr>
        <th colspan="4" class="text-end">Grand Total</th>
        <th>₹<?= number_format($grand_total, 2) ?></th>
      </tr>
    </tfoot>
  </table>

  <form method="POST" class="mt-4">
    <input type="hidden" name="order_number" value="<?= $order_number ?>">
    <button name="mark_complete" class="btn btn-primary" <?= $order['status'] === 'Completed' ? 'disabled' : '' ?>>
      ✅ Mark as Completed
    </button>
  </form>
</div>

<?php
// Handle mark as complete
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['mark_complete'])) {
  $conn->query("UPDATE orders SET status = 'Completed' WHERE order_number = '$order_number'");
  echo "<script>alert('Order marked as completed.');location.href='order_details.php?order_number=$order_number';</script>";
}
?>
