<?php 
// This should be included in the loop
$item_total = $item['price'] * $item['quantity'];
$is_pad = $item['product_type'] === 'pad';
?>
<div class="cart-item">
    <div class="row align-items-center">
        <div class="col-md-2">
            <?php if (!$is_pad && !empty($item['image'])): ?>
                <img src="uploads/<?= htmlspecialchars($item['image']) ?>" 
                     alt="<?= htmlspecialchars($item['name']) ?>" 
                     class="product-image">
            <?php else: ?>
                <div class="bg-light d-flex align-items-center justify-content-center" 
                     style="width: 100px; height: 100px; border-radius: 8px;">
                    <i class="fas fa-image text-muted"></i>
                </div>
            <?php endif; ?>
        </div>
        <div class="col-md-4">
            <h5 class="mb-1">
                <?= htmlspecialchars($item['name'] ?? 'Unnamed Product') ?>
                <?php if (!empty($item['package_name'])): ?>
                    <small class="text-muted">(<?= htmlspecialchars($item['package_name']) ?>)</small>
                <?php endif; ?>
                <br>
                <small class="text-muted">Type: <?= htmlspecialchars($item['product_type']) ?></small>
            </h5>
            <p class="text-muted mb-2">₹<?= number_format($item['price'], 2) ?></p>
            <form method="post" action="remove_from_cart.php" style="display: inline;">
                <input type="hidden" name="cart_id" value="<?= $item['cart_id'] ?>">
                <button type="submit" class="btn btn-sm btn-outline-danger">
                    <i class="fas fa-trash"></i> Remove
                </button>
            </form>
        </div>
        <div class="col-md-3">
            <form method="post" action="update_cart.php" class="d-flex align-items-center">
                <input type="hidden" name="cart_id" value="<?= $item['cart_id'] ?>">
                <button type="button" class="btn btn-sm btn-outline-secondary quantity-decrease">-</button>
                <input type="number" name="quantity" value="<?= $item['quantity'] ?>" 
                       min="1" class="form-control mx-2 quantity-input" 
                       onchange="this.form.submit()">
                <button type="button" class="btn btn-sm btn-outline-secondary quantity-increase">+</button>
            </form>
        </div>
        <div class="col-md-3 text-end">
            <strong>₹<?= number_format($item_total, 2) ?></strong>
        </div>
    </div>
</div>