<?php
session_start();
header('Content-Type: application/json');

$mysqli = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($mysqli->connect_error) {
    echo json_encode(["success" => false, "error" => "DB Connection Failed"]);
    exit;
}

$email = $_REQUEST['email'] ?? '';
if (!$email) {
    echo json_encode(["success" => false, "error" => "Missing email"]);
    exit;
}

// Create table if not exists
$mysqli->query("
CREATE TABLE IF NOT EXISTS user_cart_sync (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email VARCHAR(255) UNIQUE,
    cart_data JSON,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
)
");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $cart = json_encode($data['cart'] ?? []);
    $stmt = $mysqli->prepare("
        INSERT INTO user_cart_sync (email, cart_data)
        VALUES (?, ?)
        ON DUPLICATE KEY UPDATE cart_data = VALUES(cart_data), updated_at = CURRENT_TIMESTAMP
    ");
    $stmt->bind_param("ss", $email, $cart);
    $stmt->execute();
    echo json_encode(["success" => true]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $stmt = $mysqli->prepare("SELECT cart_data FROM user_cart_sync WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    echo json_encode(["success" => true, "cart" => json_decode($result['cart_data'] ?? '[]', true)]);
    exit;
}
?>
