<?php include 'header.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Print Type Selection - Savithri Digital</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <style>
    :root {
      --primary: #6c5ce7;
      --secondary: #00cec9;
      --accent: #fd79a8;
      --dark: #2d3436;
      --light: #f8f9fa;
      --gradient: linear-gradient(135deg, var(--primary), var(--secondary));
    }
    
    body {
      background: linear-gradient(135deg, #f5f7fa 0%, #e4e8eb 100%);
      min-height: 100vh;
      font-family: 'Poppins', sans-serif;
    }
    
    .selection-container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 80px 20px;
      position: relative;
      overflow: hidden;
    }
    
    .page-title {
      font-size: 2.5rem;
      font-weight: 800;
      margin-bottom: 60px;
      color: var(--dark);
      text-align: center;
      position: relative;
      display: inline-block;
      width: 100%;
    }
    
    .page-title::after {
      content: '';
      position: absolute;
      bottom: -15px;
      left: 50%;
      transform: translateX(-50%);
      width: 80px;
      height: 4px;
      background: var(--gradient);
      border-radius: 2px;
    }
    
    .selection-card {
      background: white;
      border-radius: 20px;
      overflow: hidden;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
      transition: all 0.5s cubic-bezier(0.25, 0.8, 0.25, 1);
      height: 100%;
      position: relative;
      border: none;
    }
    
    .selection-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 5px;
      background: var(--gradient);
      transition: all 0.3s ease;
    }
    
    .selection-card:hover {
      transform: translateY(-10px);
      box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
    }
    
    .selection-card:hover::before {
      height: 8px;
    }
    
    .card-header {
      background: white;
      border: none;
      padding: 30px 30px 20px;
      position: relative;
    }
    
    .section-title {
      font-size: 1.5rem;
      font-weight: 700;
      color: var(--dark);
      margin: 0;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    
    .section-title i {
      margin-right: 12px;
      font-size: 1.8rem;
      background: var(--gradient);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
    }
    
    .card-body {
      padding: 0 30px 30px;
    }
    
    .option-link {
      display: block;
      background: #f8f9fa;
      color: var(--dark);
      padding: 18px 25px;
      border-radius: 12px;
      margin-bottom: 15px;
      text-decoration: none;
      font-weight: 500;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
      border-left: 4px solid transparent;
    }
    
    .option-link:last-child {
      margin-bottom: 0;
    }
    
    .option-link::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 0;
      height: 100%;
      background: linear-gradient(90deg, rgba(108, 92, 231, 0.1), transparent);
      transition: width 0.3s ease;
    }
    
    .option-link:hover {
      transform: translateX(10px);
      background: #f1f3f5;
      border-left-color: var(--primary);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }
    
    .option-link:hover::before {
      width: 100%;
    }
    
    .option-link i {
      margin-right: 10px;
      color: var(--primary);
      transition: transform 0.3s ease;
    }
    
    .option-link:hover i {
      transform: translateX(5px);
    }
    
    /* Floating Elements */
    .floating-shape {
      position: absolute;
      border-radius: 50%;
      opacity: 0.1;
      z-index: -1;
      animation: float 15s infinite ease-in-out;
    }
    
    .shape-1 {
      width: 200px;
      height: 200px;
      top: 10%;
      left: 5%;
      background: var(--primary);
      animation-delay: 0s;
    }
    
    .shape-2 {
      width: 300px;
      height: 300px;
      bottom: 10%;
      right: 5%;
      background: var(--secondary);
      animation-delay: 3s;
      animation-duration: 20s;
    }
    
    @keyframes float {
      0%, 100% { transform: translateY(0) rotate(0deg); }
      50% { transform: translateY(-20px) rotate(5deg); }
    }
    
    /* Responsive Styles */
    @media (max-width: 768px) {
      .selection-container {
        padding: 60px 15px;
      }
      
      .page-title {
        font-size: 2rem;
        margin-bottom: 40px;
      }
      
      .section-title {
        font-size: 1.3rem;
      }
      
      .option-link {
        padding: 15px 20px;
      }
    }
    
    @media (max-width: 576px) {
      .page-title {
        font-size: 1.8rem;
      }
      
      .card-header {
        padding: 25px 20px 15px;
      }
      
      .card-body {
        padding: 0 20px 25px;
      }
    }
  </style>
</head>
<body>
  <div class="selection-container">
    <!-- Floating Shapes -->
    <div class="floating-shape shape-1"></div>
    <div class="floating-shape shape-2"></div>
    
    <h1 class="page-title animate__animated animate__fadeInDown">Select Print Type</h1>
    
    <div class="row justify-content-center">
      <div class="col-lg-6 col-md-8">
        <div class="selection-card animate__animated animate__fadeInUp">
          <div class="card-header text-center">
            <h2 class="section-title">
              <i class="fas fa-print"></i> Print Options
            </h2>
          </div>
          <div class="card-body">
            <a href="packages.php?print_category_id=1" class="option-link animate__animated animate__fadeInLeft" style="animation-delay: 0.2s">
              <i class="fas fa-boxes"></i> Combo Packages
            </a>
            <a href="hp_indigo.php" class="option-link animate__animated animate__fadeInLeft" style="animation-delay: 0.3s">
              <i class="fas fa-gift"></i> Special Packages
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Add smooth hover effect to option links
    document.querySelectorAll('.option-link').forEach(link => {
      link.addEventListener('mouseenter', function() {
        this.style.transform = 'translateX(10px)';
      });
      
      link.addEventListener('mouseleave', function() {
        this.style.transform = 'translateX(0)';
      });
    });
    
    // Add animation on scroll
    document.addEventListener('DOMContentLoaded', function() {
      const cards = document.querySelectorAll('.selection-card');
      
      const observerOptions = {
        threshold: 0.2,
        rootMargin: '0px 0px -50px 0px'
      };
      
      const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            entry.target.classList.add('animate__animated', 'animate__fadeInUp');
            observer.unobserve(entry.target);
          }
        });
      }, observerOptions);
      
      cards.forEach(card => {
        observer.observe(card);
      });
    });
  </script>
</body>
</html>
<?php include 'footer.php'; ?>