<?php
session_start();
include 'header.php';

$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Ensure user is logged in
if (!isset($_SESSION['email'])) {
    die("You must log in first.");
}

// Get user region
$user_email = $_SESSION['email'];
$user_stmt = $conn->prepare("SELECT region FROM users WHERE email = ?");
$user_stmt->bind_param("s", $user_email);
$user_stmt->execute();
$user_res = $user_stmt->get_result();
if ($user_res->num_rows === 0) {
    die("User not found.");
}
$user_data = $user_res->fetch_assoc();
$user_region = strtolower(trim($user_data['region']));

// Select correct MRP column based on region
$mrp_column = ($user_region === "region 2") ? "mrp_region" : "mrp";

// Get and validate package ID
$package_id = $_GET['package_id'] ?? null;
if (!$package_id || !is_numeric($package_id)) {
    die("Invalid or missing package ID.");
}

// Get package name
// Get package name and description
$package_stmt = $conn->prepare("SELECT name, description, image FROM packages WHERE id = ?");


$package_stmt->bind_param("i", $package_id);
$package_stmt->execute();
$package_result = $package_stmt->get_result();
$package = $package_result->fetch_assoc();

// Fetch products with correct MRP column
$product_query = "SELECT id, name, description, image, $mrp_column AS mrp, selling_price 
                  FROM products 
                  WHERE package_id = ?";
$product_stmt = $conn->prepare($product_query);
$product_stmt->bind_param("i", $package_id);
$product_stmt->execute();
$products = $product_stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
  <title><?= htmlspecialchars($package['name']) ?> - Savithri Digital</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <style>
    :root {
      --primary: #6c5ce7;
      --primary-light: #a29bfe;
      --secondary: #00cec9;
      --accent: #ff6b6b;
      --dark: #1e272e;
      --light: #f8f9fa;
      --gray: #8e9aaf;
      --light-gray: #f1f2f6;
      --gradient: linear-gradient(135deg, var(--primary), var(--secondary));
      --shadow: 0 4px 20px rgba(0,0,0,0.05);
      --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
    }
    
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
    
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      -webkit-tap-highlight-color: transparent;
      -webkit-font-smoothing: antialiased;
    }
    
    body {
      background: #f8f9ff;
      font-family: 'Poppins', sans-serif;
      color: var(--dark);
      line-height: 1.5;
      overflow-x: hidden;
    }
    
    /* Header Styles */
    .app-header {
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      background: white;
      z-index: 1000;
      box-shadow: 0 2px 15px rgba(0,0,0,0.05);
      padding: 15px 0;
    }
    
    .header-content {
      max-width: 100%;
      margin: 0 auto;
      padding: 0 15px;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }
    
    .header-left {
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    .back-btn {
      width: 36px;
      height: 36px;
      border-radius: 50%;
      background: var(--light-gray);
      border: none;
      display: flex;
      align-items: center;
      justify-content: center;
      color: var(--dark);
      font-size: 1rem;
      transition: var(--transition);
    }
    
    .back-btn:active {
      transform: scale(0.95);
      background: #e2e6ea;
    }
    
    .page-title {
      font-size: 1.1rem;
      font-weight: 700;
      color: var(--dark);
      margin: 0;
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      max-width: 180px;
    }
    
    .header-actions {
      display: flex;
      align-items: center;
      gap: 12px;
    }
    
    .header-icon {
      width: 36px;
      height: 36px;
      border-radius: 50%;
      background: var(--light-gray);
      display: flex;
      align-items: center;
      justify-content: center;
      color: var(--dark);
      font-size: 1rem;
      text-decoration: none;
      position: relative;
      transition: var(--transition);
    }
    
    .header-icon:active {
      transform: scale(0.95);
      background: #e2e6ea;
    }
    
    .cart-count {
      position: absolute;
      top: -5px;
      right: -5px;
      background: var(--accent);
      color: white;
      width: 18px;
      height: 18px;
      border-radius: 50%;
      font-size: 0.6rem;
      font-weight: 700;
      display: flex;
      align-items: center;
      justify-content: center;
      border: 2px solid white;
      display: none;
    }
    
    .cart-count.active {
      display: flex;
    }
    .simple-card {
  display: flex;
  flex-direction: column;
  justify-content: space-between;
  background: white;
  border-radius: 14px;
  box-shadow: 0 4px 15px rgba(0,0,0,0.05);
  padding: 16px;
  transition: all 0.3s ease;
  height: 100%;
}

.simple-card:hover {
  transform: translateY(-3px);
  box-shadow: 0 6px 18px rgba(0,0,0,0.08);
}

.simple-card .product-details {
  padding: 0;
}

.simple-card .product-name {
  font-size: 0.95rem;
  font-weight: 600;
  margin-bottom: 6px;
  color: #212529;
}

.simple-card .product-desc {
  font-size: 0.8rem;
  color: #6c757d;
  line-height: 1.4;
  margin-bottom: 10px;
  height: 2.2em;
  overflow: hidden;
  text-overflow: ellipsis;
}

.simple-card .price-row {
  display: flex;
  align-items: baseline;
  gap: 6px;
  margin-bottom: 8px;
}

.simple-card .current-price {
  color: var(--primary);
  font-size: 1rem;
  font-weight: 700;
}

.simple-card .original-price {
  color: #adb5bd;
  text-decoration: line-through;
  font-size: 0.8rem;
}

.simple-card .add-to-cart-btn {
  border-radius: 8px;
  background: var(--gradient);
  font-weight: 600;
  padding: 10px;
  color: white;
  border: none;
  cursor: pointer;
  transition: all 0.3s ease;
}

.simple-card .add-to-cart-btn:hover {
  opacity: 0.9;
}

.banner-image {
  width: 100%;
  height: 250px;
  border-radius: 14px;
  overflow: hidden;
  margin-bottom: 15px;
  box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.package-img {
  width: 100%;
  height: auto;
  object-fit: cover;
  border-radius: 14px;
  transition: transform 0.4s ease;
}

.package-img:hover {
  transform: scale(1.03);
}

    
    /* Main Content */
    .app-container {
      
      padding: 15px 10px 80px;
      max-width: 100%;
    }
    
    /* Category Banner */
    .category-banner {
      background: var(--gradient);
      border-radius: 16px;
      padding: 20px;
      margin-bottom: 20px;
      color: white;
      position: relative;
      overflow: hidden;
    }
    
    .category-banner::before {
      content: '';
      position: absolute;
      top: -50%;
      right: -50%;
      width: 200%;
      height: 200%;
      background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 50%);
      transform: rotate(30deg);
    }
    
    .category-banner h1 {
      font-size: 1.3rem;
      font-weight: 800;
      margin-bottom: 8px;
      position: relative;
    }
    
    .category-banner p {
      font-size: 0.85rem;
      opacity: 0.9;
      margin: 0;
      max-width: 80%;
      position: relative;
    }
    
    /* Products Grid */
    .products-grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 12px;
      padding: 0 5px;
    }
    
    .product-card {
      background: white;
      border-radius: 14px;
      overflow: hidden;
      box-shadow: var(--shadow);
      transition: var(--transition);
      position: relative;
      border: 1px solid rgba(0,0,0,0.02);
      display: flex;
      flex-direction: column;
      height: 100%;
    }
    
    .product-card:active {
      transform: scale(0.98);
    }
    
    .product-badge {
      position: absolute;
      top: 10px;
      right: 10px;
      background: var(--accent);
      color: white;
      font-size: 0.65rem;
      font-weight: 700;
      padding: 4px 8px;
      border-radius: 20px;
      z-index: 2;
      box-shadow: 0 4px 10px rgba(255,107,107,0.3);
    }
    
    .wishlist-btn {
      position: absolute;
      top: 10px;
      left: 10px;
      width: 30px;
      height: 30px;
      border-radius: 50%;
      background: white;
      border: none;
      color: #ccc;
      font-size: 0.9rem;
      display: flex;
      align-items: center;
      justify-content: center;
      z-index: 2;
      opacity: 0;
      transform: translateY(5px);
      transition: var(--transition);
      box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    }
    
    .product-card:hover .wishlist-btn {
      opacity: 1;
      transform: translateY(0);
    }
    
    .wishlist-btn.active {
      color: var(--accent);
      opacity: 1;
      transform: translateY(0);
    }
    
    .product-image-container {
      position: relative;
      padding-top: 100%;
      background: linear-gradient(45deg, #f8f9ff, #f0f2ff);
      overflow: hidden;
    }
    
    .product-image {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      object-fit: contain;
      padding: 20px;
      transition: transform 0.6s cubic-bezier(0.25, 0.8, 0.25, 1);
    }
    
    .product-card:hover .product-image {
      transform: scale(1.08);
    }
    
    .product-details {
      padding: 14px;
      flex-grow: 1;
      display: flex;
      flex-direction: column;
    }
    
    .product-name {
      font-size: 0.9rem;
      font-weight: 600;
      margin: 0 0 8px;
      color: var(--dark);
      line-height: 1.3;
      min-height: 2.3em;
      display: -webkit-box;
      -webkit-line-clamp: 2;
      -webkit-box-orient: vertical;
      overflow: hidden;
    }
    
    .product-category {
      font-size: 0.7rem;
      color: var(--gray);
      margin-bottom: 8px;
      display: inline-block;
      background: var(--light-gray);
      padding: 2px 8px;
      border-radius: 10px;
      align-self: flex-start;
    }
    
    .price-container {
      margin-top: auto;
    }
    
    .price-row {
      display: flex;
      align-items: center;
      margin-bottom: 10px;
      flex-wrap: wrap;
      gap: 5px;
    }
    
    .current-price {
      font-size: 1.1rem;
      font-weight: 800;
      color: var(--primary);
    }
    
    .original-price {
      font-size: 0.75rem;
      color: #adb5bd;
      text-decoration: line-through;
    }
    
    .discount-badge {
      background: #ffebee;
      color: #f44336;
      font-size: 0.65rem;
      font-weight: 700;
      padding: 2px 6px;
      border-radius: 4px;
    }
    
    .add-to-cart-btn {
      display: flex;
      align-items: center;
      justify-content: center;
      width: 100%;
      background: var(--gradient);
      color: white;
      border: none;
      padding: 8px;
      border-radius: 8px;
      font-weight: 600;
      font-size: 0.8rem;
      transition: var(--transition);
      cursor: pointer;
      margin-top: 5px;
      position: relative;
      overflow: hidden;
    }
    
    .add-to-cart-btn::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: linear-gradient(rgba(255,255,255,0.1), transparent);
      opacity: 0;
      transition: var(--transition);
    }
    
    .add-to-cart-btn:active::before {
      opacity: 1;
    }
    
    .add-to-cart-btn i {
      margin-right: 5px;
      font-size: 0.9rem;
      transition: var(--transition);
    }
    
    .add-to-cart-btn.added {
      background: #4caf50;
    }
    
    .add-to-cart-btn.added i {
      transform: scale(1.2);
    }
    
    /* Bottom Navigation */
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: white;
      box-shadow: 0 -2px 15px rgba(0,0,0,0.05);
      padding: 10px 0;
      z-index: 900;
    }
    
    .nav-items {
      display: flex;
      justify-content: space-around;
      max-width: 500px;
      margin: 0 auto;
    }
    
    .nav-item {
      display: flex;
      flex-direction: column;
      align-items: center;
      text-decoration: none;
      color: var(--gray);
      font-size: 0.7rem;
      padding: 5px 10px;
      border-radius: 8px;
      transition: var(--transition);
    }
    
    .nav-item i {
      font-size: 1.2rem;
      margin-bottom: 3px;
    }
    
    .nav-item.active {
      color: var(--primary);
    }
    
    .nav-item:active {
      background: var(--light-gray);
    }
    
    /* Toast Notification */
    .toast {
      position: fixed;
      bottom: 70px;
      left: 50%;
      transform: translateX(-50%) translateY(100px);
      background: rgba(0,0,0,0.9);
      color: white;
      padding: 12px 20px;
      border-radius: 10px;
      font-size: 0.9rem;
      z-index: 1000;
      opacity: 0;
      transition: all 0.4s cubic-bezier(0.68, -0.55, 0.27, 1.55);
      display: flex;
      align-items: center;
      gap: 8px;
      max-width: 90%;
      box-shadow: 0 5px 20px rgba(0,0,0,0.15);
    }
    
    .toast.show {
      opacity: 1;
      transform: translateX(-50%) translateY(0);
    }
    
    .toast i {
      font-size: 1.1rem;
    }
    
    /* Empty State */
    .empty-state {
      grid-column: 1 / -1;
      text-align: center;
      padding: 50px 20px;
      background: white;
      border-radius: 16px;
      box-shadow: var(--shadow);
      margin-top: 20px;
    }
    
    .empty-state i {
      font-size: 2.5rem;
      color: #dee2e6;
      margin-bottom: 15px;
    }
    
    .empty-state h4 {
      color: var(--dark);
      margin-bottom: 10px;
      font-size: 1.1rem;
    }
    
    .empty-state p {
      color: #6c757d;
      font-size: 0.9rem;
      margin: 0;
      max-width: 300px;
      margin: 0 auto;
    }
    
    /* Responsive Adjustments */
    @media (min-width: 400px) {
      .products-grid {
        gap: 15px;
        padding: 0 10px;
      }
      
      .product-details {
        padding: 16px;
      }
      
      .product-name {
        font-size: 0.95rem;
      }
      
      .current-price {
        font-size: 1.15rem;
      }
    }
    
    @media (min-width: 576px) {
      .app-container {
        max-width: 540px;
        margin: 66px auto 0;
        padding: 20px 15px 100px;
      }
      
      .products-grid {
        gap: 18px;
      }
      
      .product-card {
        border-radius: 16px;
      }
      
      .category-banner {
        padding: 25px;
      }
      
      .category-banner h1 {
        font-size: 1.5rem;
      }
      
      .category-banner p {
        font-size: 0.95rem;
      }
    }
    
    @media (min-width: 768px) {
      .app-container {
        max-width: 720px;
      }
      
      .products-grid {
        grid-template-columns: repeat(2, 1fr);
      }
    }
    .cart-count {
  position: absolute;
  top: -5px;
  right: -5px;
  background: var(--accent);
  color: white;
  width: 18px;
  height: 18px;
  border-radius: 50%;
  font-size: 0.6rem;
  font-weight: 700;
  display: flex;
  align-items: center;
  justify-content: center;
  border: 2px solid white;
  display: none;
}

.cart-count.active {
  display: flex;
}

  </style>
</head>
<body>
    <!-- Header -->


  <!-- Header -->
  
  <!-- Main Content -->
  <main class="app-container">
    <!-- Category Banner -->
    <div class="category-banner">
  <?php if (!empty($package['image'])): ?>
    <div class="banner-image">
      <img src="images/<?= htmlspecialchars($package['image']) ?>" 
           alt="<?= htmlspecialchars($package['name']) ?>" 
           class="img-fluid package-img">
    </div>
  <?php endif; ?>

  <h1><?= htmlspecialchars($package['name']) ?></h1>
  <?php if (!empty($package['description'])): ?>
    <p><?= htmlspecialchars($package['description']) ?></p>
  <?php else: ?>
    <p>Explore our premium collection</p>
  <?php endif; ?>
</div>


    <!-- Products Grid -->
   <!-- Products Grid -->
<div class="products-grid">
  <?php if ($products->num_rows > 0): ?>
    <?php while($product = $products->fetch_assoc()): 
      $has_discount = !empty($product['selling_price']) && $product['selling_price'] < $product['mrp'];
      $discount = $has_discount ? round((($product['mrp'] - $product['selling_price']) / $product['mrp']) * 100) : 0;
      $price = $has_discount ? $product['selling_price'] : $product['mrp'];
    ?>
      <div class="product-card simple-card" data-product-id="<?= $product['id'] ?>">
        <?php if ($has_discount && $discount > 0): ?>
          <span class="product-badge"><?= $discount ?>% OFF</span>
        <?php endif; ?>

        <div class="product-details">
          <h3 class="product-name"><?= htmlspecialchars($product['name']) ?></h3>
          <?php if (!empty($product['description'])): ?>
            <p class="product-desc"><?= htmlspecialchars($product['description']) ?></p>
          <?php endif; ?>

          <div class="price-container">
            <div class="price-row">
              <span class="current-price">₹<?= number_format($price, 2) ?></span>
              <?php if ($has_discount): ?>
                <span class="original-price">₹<?= number_format($product['mrp'], 2) ?></span>
              <?php endif; ?>
            </div>
            <button class="add-to-cart-btn" 
        onclick="addToCart(<?= htmlspecialchars(json_encode($product)) ?>, this)">
    <i class="fas fa-plus"></i> Add to Cart
</button>

          </div>
        </div>
      </div>
    <?php endwhile; ?>
  <?php else: ?>
    <div class="empty-state">
      <i class="fas fa-box-open"></i>
      <h4>No Products Found</h4>
      <p>We couldn't find any products in this category. Please check back later.</p>
    </div>
  <?php endif; ?>
</div>

  </main>

  <!-- Bottom Navigation -->
  

  <!-- Toast Notification -->
  <div class="toast" id="toast">
    <i class="fas fa-check-circle"></i>
    <span id="toastMessage">Item added to cart</span>
  </div>

<script>
// ================== CART & WISHLIST SYSTEM ==================

// âœ… Logged-in user's email (for cross-device sync)
const userEmail = "<?php echo $_SESSION['email'] ?? ''; ?>";
let cart = JSON.parse(localStorage.getItem("cart") || "[]");
let wishlist = JSON.parse(localStorage.getItem("wishlist") || "[]");

// ================== CART COUNT HANDLER ==================
function updateCartCount() {
  const totalItems = cart.reduce((sum, item) => sum + (item.quantity || 1), 0);
  const cartCount = document.getElementById("cartCount");

  if (cartCount) {
    if (totalItems > 0) {
      cartCount.textContent = totalItems > 9 ? "9+" : totalItems;
      cartCount.classList.add("active");
      cartCount.style.display = "flex";
    } else {
      cartCount.classList.remove("active");
      cartCount.style.display = "none"; // hides when 0
    }
  }
  return totalItems;
}


// ================== WISHLIST HANDLERS ==================
function isInWishlist(productId) {
    return wishlist.some(item => item.id === productId);
}

function toggleWishlist(button, product) {
    const productId = typeof product === "object" ? product.id : product;
    const index = wishlist.findIndex(item => item.id === productId);

    if (index === -1) {
        wishlist.push(typeof product === "object" ? product : { id: productId });
        button.innerHTML = '<i class="fas fa-heart"></i>';
        button.classList.add("active");
        showToast("Added to wishlist");
    } else {
        wishlist.splice(index, 1);
        button.innerHTML = '<i class="far fa-heart"></i>';
        button.classList.remove("active");
        showToast("Removed from wishlist");
    }

    localStorage.setItem("wishlist", JSON.stringify(wishlist));
    updateWishlistButtons();
}

function updateWishlistButtons() {
    document.querySelectorAll(".wishlist-btn").forEach(button => {
        const productId = button.closest(".product-card")?.dataset.productId;
        if (!productId) return;

        if (isInWishlist(parseInt(productId))) {
            button.innerHTML = '<i class="fas fa-heart"></i>';
            button.classList.add("active");
        } else {
            button.innerHTML = '<i class="far fa-heart"></i>';
            button.classList.remove("active");
        }
    });
}

// ================== TOAST NOTIFICATION ==================
function showToast(message) {
    const toast = document.getElementById("toast");
    const toastMessage = document.getElementById("toastMessage");

    if (!toast || !toastMessage) return;

    toastMessage.textContent = message;
    toast.classList.add("show");

    const icon = toast.querySelector("i");
    if (message.includes("wishlist")) {
        icon.className = message.includes("Added") ? "fas fa-heart" : "far fa-heart";
    } else if (message.includes("cart")) {
        icon.className = "fas fa-shopping-cart";
    } else {
        icon.className = "fas fa-check-circle";
    }

    setTimeout(() => toast.classList.remove("show"), 3000);
}

// ================== ADD TO CART FUNCTION ==================
async function addToCart(productOrObj, button) {
  // determine product id
  let productId = 0;
  if (!productOrObj) return;
  if (typeof productOrObj === 'object') {
    productId = productOrObj.id || productOrObj.product_id || 0;
  } else {
    productId = Number(productOrObj) || 0;
  }
  if (!productId) return alert('Invalid product');

  // button visual
  const originalHTML = button && button.innerHTML ? button.innerHTML : null;
  if (button) {
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
    button.disabled = true;
  }

  try {
    const response = await fetch('add_to_cart.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      credentials: 'same-origin',
      body: JSON.stringify({ 
        product_id: productId, 
        quantity: 1 
      })
    });

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const data = await response.json();
    
    if (data && data.success) {
      // Update cart count in header
      if (window.__updateCartBadge) {
        window.__updateCartBadge(Number(data.cart_count || 0));
      }
      
      // Dispatch cart updated event
      document.dispatchEvent(new CustomEvent('cartUpdated', { 
        detail: { count: Number(data.cart_count || 0) } 
      }));
      
      // Show success message
      showToast('Added to cart');
      
    } else {
      const error = data?.error || 'Failed to add to cart';
      showToast(error);
      console.error('Add to cart error:', error);
    }
  } catch (error) {
    console.error('Add to cart error:', error);
    showToast('Error adding to cart. Please try again.');
  } finally {
    // Reset button state
    if (button && originalHTML) {
      setTimeout(() => {
        button.innerHTML = originalHTML;
        button.disabled = false;
      }, 800);
    }
  }
}

// ================== RIPPLE EFFECT ==================
function addRippleEffect(button, e) {
    const ripple = document.createElement("span");
    const rect = button.getBoundingClientRect();
    const size = Math.max(rect.width, rect.height);

    ripple.style.width = ripple.style.height = `${size}px`;
    ripple.style.left = `${e.clientX - rect.left - size / 2}px`;
    ripple.style.top = `${e.clientY - rect.top - size / 2}px`;
    ripple.classList.add("ripple");

    const existing = button.querySelector(".ripple");
    if (existing) existing.remove();

    button.appendChild(ripple);
    setTimeout(() => ripple.remove(), 600);
}

// ================== CART SYNC (CROSS DEVICE) ==================
async function syncCartToServer() {
    if (!userEmail) return; // only sync for logged-in users
    try {
        await fetch("cart_sync.php", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ email: userEmail, cart })
        });
    } catch (e) {
        console.warn("Cart sync failed:", e);
    }
}

async function loadCartFromServer() {
    if (!userEmail) return;
    try {
        const response = await fetch(`cart_sync.php?email=${encodeURIComponent(userEmail)}`);
        const data = await response.json();
        if (data.success && data.cart) {
            cart = data.cart;
            localStorage.setItem("cart", JSON.stringify(cart));
            updateCartCount();
        }
    } catch (e) {
        console.warn("Cart load failed:", e);
    }
}

// ================== INITIALIZATION ==================
document.addEventListener("DOMContentLoaded", () => {
    updateCartCount();
    updateWishlistButtons();
    loadCartFromServer(); // ðŸ‘ˆ loads synced cart from DB

    document.querySelectorAll(".product-card").forEach((card, i) => {
        card.style.opacity = "0";
        card.style.transform = "translateY(20px)";
        card.style.transition = `all 0.4s ease ${i * 0.05}s`;

        setTimeout(() => {
            card.style.opacity = "1";
            card.style.transform = "translateY(0)";
        }, 100);
    });

    document.addEventListener("click", (e) => {
        const button = e.target.closest("button");
        if (button) addRippleEffect(button, e);
    });
});
</script>
<script>
document.addEventListener("DOMContentLoaded", function() {
  const cartCountEl = document.getElementById("cartCount");

  // ✅ Update count from server
  async function updateCartCount() {
    try {
      const res = await fetch("get_cart_count.php");
      const data = await res.json();
      const count = data.count || 0;

      if (count > 0) {
        cartCountEl.textContent = count;
        cartCountEl.classList.add("active");
        cartCountEl.style.display = "flex";
      } else {
        cartCountEl.textContent = "0";
        cartCountEl.classList.remove("active");
        cartCountEl.style.display = "none";
      }
    } catch (e) {
      console.error("Cart count error:", e);
    }
  }

  // ✅ Run immediately when page loads
  updateCartCount();

  // ✅ Listen for "cartUpdated" event (triggered after add-to-cart)
  document.addEventListener("cartUpdated", updateCartCount);
});
</script>


</body>
</html>
