<meta name="viewport" content="width=device-width, initial-scale=1">
<?php 
include 'header.php'; 
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

// If a category is selected, fetch pads from that category
$selected_category = isset($_GET['category_id']) ? intval($_GET['category_id']) : 0;

// Fetch all categories
$categories = $conn->query("SELECT * FROM pad_categories ORDER BY sort_order ASC");


// Fetch pads if a category is selected
$pads = null;
if ($selected_category > 0) {
    $pads = $conn->query("SELECT p.*, c.name as category 
                          FROM pads p 
                          JOIN pad_categories c ON p.category_id = c.id
                          WHERE p.category_id = $selected_category
                          ORDER BY p.pad_name ASC");
}
?>

<div class="container py-5">

  <h2 class="text-center text-primary mb-4 fw-bold">✨ Pad Designs ✨</h2>

  <!-- Show categories if no category is selected -->
  <?php if ($selected_category == 0): ?>
    <div class="row">
      <?php while ($cat = $categories->fetch_assoc()): ?>
        <div class="col-6 col-md-3 mb-4">
          <a href="?category_id=<?= $cat['id'] ?>" class="text-decoration-none">
            <div class="card text-center shadow-sm border-0 rounded-4 p-3 h-100">
              <img src="images/bullet-point.png" alt="<?= htmlspecialchars($cat['name']) ?>" 
                   style="width:60px; height:60px; object-fit:contain; margin: 0 auto;">
              <h6 class="mt-3 text-dark fw-semibold"><?= htmlspecialchars($cat['name']) ?></h6>
            </div>
          </a>
        </div>
      <?php endwhile; ?>
    </div>
  <?php else: ?>

    <!-- Back Button -->
    <div class="mb-4">
      <a href="pad_designs.php" class="btn btn-outline-secondary btn-sm">← Back to Categories</a>
    </div>

    <!-- Show pads for selected category -->
    <div class="row row-cols-2 row-cols-md-3 g-4">
      <?php while ($pad = $pads->fetch_assoc()): ?>
        <div class="col">
          <div class="card h-100 shadow-sm border-0 rounded-4">
            <img src="/savithridigital/images/<?= htmlspecialchars($pad['image_path']) ?>" 
                 class="card-img-top rounded-top-4"
                 alt="<?= htmlspecialchars($pad['pad_name']) ?>" 
                 style="height: 180px; object-fit: cover;">
            <div class="card-body text-center">
              <h6 class="fw-semibold"><?= htmlspecialchars($pad['pad_name']) ?></h6>
              <button class="btn btn-outline-primary btn-sm mt-2" 
                      onclick='addToCart(<?= json_encode($pad) ?>)'>🛒 Add to Cart</button>
            </div>
          </div>
        </div>
      <?php endwhile; ?>
    </div>
  <?php endif; ?>

</div>

<script>
function addToCart(product) {
  let cart = JSON.parse(localStorage.getItem("cart") || "[]");
  cart.push({ ...product, category: 'pad_design' });
  localStorage.setItem("cart", JSON.stringify(cart));
  alert("✅ Added to cart!");
}
</script>
