<?php 
include 'includes/auth.php'; 
include 'includes/header.php'; 

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

// Check connection
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

// Fetch categories for dropdown
$categories = $conn->query("SELECT * FROM pad_categories");

// Handle form submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $pad_name   = $conn->real_escape_string($_POST['pad_name']);
  $category_id = (int)$_POST['category_id'];

  $sql = "INSERT INTO pads (pad_name, category_id) VALUES ('$pad_name', '$category_id')";
  if ($conn->query($sql)) {
    echo "<script>alert('Pad added successfully'); location.href='add_pad.php';</script>";
    exit;
  } else {
    echo "<div class='alert alert-danger'>Error: " . $conn->error . "</div>";
  }
}

// ---------------- Pagination ----------------
$limit = 10; // rows per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$offset = ($page - 1) * $limit;

// Count total records
$countRes = $conn->query("SELECT COUNT(*) as total FROM pads");
$totalRows = $countRes->fetch_assoc()['total'];
$totalPages = ceil($totalRows / $limit);

// Fetch paginated pads
$padsRes = $conn->query("SELECT p.id, p.pad_name, c.name AS category 
                         FROM pads p 
                         LEFT JOIN pad_categories c ON p.category_id = c.id
                         ORDER BY p.id DESC
                         LIMIT $limit OFFSET $offset");
?>

<div class="container mt-4">
  <h3 class="mb-3">➕ Add New Pad</h3>

  <form method="POST" class="mb-4">
    <div class="mb-3">
      <label class="form-label">Pad Name</label>
      <input type="text" name="pad_name" class="form-control" placeholder="Enter pad name" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Category</label>
      <select name="category_id" class="form-select" required>
        <option value="">Select Category</option>
        <?php while ($cat = $categories->fetch_assoc()): ?>
          <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
        <?php endwhile; ?>
      </select>
    </div>

    <button class="btn btn-success">Add Pad</button>
  </form>

  
</div>

<?php include 'includes/footer.php'; ?>
