<?php 
include 'includes/auth.php'; 
include 'includes/header.php'; 

// DB connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Pagination
$limit = 10; 
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$offset = ($page - 1) * $limit;

// Count total pad types
$countRes = $conn->query("SELECT COUNT(*) as total FROM pad_types");
$totalRows = $countRes->fetch_assoc()['total'];
$totalPages = ceil($totalRows / $limit);

// Fetch pad types + prices
$sql = "
    SELECT pt.id, pt.name, pt.image, pp.price, pp.price_region
    FROM pad_types pt
    LEFT JOIN pad_prices pp ON pt.id = pp.pad_type_id
    ORDER BY pt.id DESC, pp.price_region ASC
    LIMIT $limit OFFSET $offset
";
$result = $conn->query($sql);
?>

<div class="container mt-4">
  <h3 class="mb-3">📑 Pad Types & Region Prices</h3>

  <table class="table table-bordered table-striped align-middle">
    <thead class="table-light">
      <tr>
        <th>#</th>
        <th>Pad Type</th>
        <th>Region 1</th>
        <th>Region 2</th>
      </tr>
    </thead>
    <tbody>
      <?php if ($result && $result->num_rows > 0): $i = $offset + 1; ?>
        <?php while ($row = $result->fetch_assoc()): ?>
          <tr>
            <td><?= $i++ ?></td>
            <td><?= htmlspecialchars($row['name']) ?></td>
            <td><?= htmlspecialchars($row['price_region'] ?? '-') ?></td>
            <td><?= $row['price'] !== null ? '₹'.number_format($row['price'], 2) : '-' ?></td>
          </tr>
        <?php endwhile; ?>
      <?php else: ?>
        <tr><td colspan="5" class="text-center">No pad types found</td></tr>
      <?php endif; ?>
    </tbody>
  </table>

  <!-- Pagination -->
  <nav>
    <ul class="pagination justify-content-center">
      <?php if ($page > 1): ?>
        <li class="page-item">
          <a class="page-link" href="?page=<?= $page-1 ?>">Previous</a>
        </li>
      <?php endif; ?>

      <?php for ($i = 1; $i <= $totalPages; $i++): ?>
        <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
          <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
        </li>
      <?php endfor; ?>

      <?php if ($page < $totalPages): ?>
        <li class="page-item">
          <a class="page-link" href="?page=<?= $page+1 ?>">Next</a>
        </li>
      <?php endif; ?>
    </ul>
  </nav>
</div>

<?php include 'includes/footer.php'; ?>
