<?php
include 'header.php';

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

$packages = $conn->query("SELECT * FROM premium_packages");
?>

<!DOCTYPE html>
<html>
<head>
  <title>Premium Pad Packages</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #f8f9fa;
      font-family: 'Segoe UI', sans-serif;
    }
    .package-card {
      background: #fff;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
      transition: 0.3s;
      height: 100%;
    }
    .package-card:hover {
      transform: translateY(-4px);
    }
    .package-card img {
         width: 53%;
      height: 180px;
      object-fit: cover;
      border-radius: 10px;
      margin-bottom: 15px;
    }
    .package-title {
      font-size: 1.1rem;
      font-weight: bold;
      margin-bottom: 5px;
    }
    .package-price {
      font-weight: bold;
      color: #28a745;
    }
    .add-cart-btn {
      background: #0d6efd;
      border: none;
      padding: 6px 10px;
      border-radius: 8px;
      color: white;
    }
  </style>
</head>
<body>

<div class="container py-5">
  <h2 class="text-center mb-5">Premium Pad Packages</h2>
  <div class="row g-4">
    <?php while($row = $packages->fetch_assoc()): ?>
      <div class="col-md-6">
        <div class="package-card">
           
          <div class="package-title"><?= htmlspecialchars($row['title']) ?></div>
          <p><?= nl2br(htmlspecialchars($row['description'])) ?></p>
          <div class="d-flex justify-content-between align-items-center mt-3">
            <span class="package-price">₹<?= number_format($row['price'], 2) ?></span>
            <button class="add-cart-btn" onclick='addToCart(<?= json_encode($row) ?>)'>🛒</button>
          </div>
        </div>
      </div>
    <?php endwhile; ?>
  </div>
</div>

<script>
function addToCart(item) {
  let cart = JSON.parse(localStorage.getItem("cart") || "[]");
  cart.push({
    productId: item.id,
    name: item.title,
    description: item.description,
    price: item.price,
    image: item.image
  });
  localStorage.setItem("cart", JSON.stringify(cart));
  alert("Added to cart!");
}
</script>

</body>
</html>
