<?php 
include 'header.php'; 
session_start();

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if user is logged in
if (!isset($_SESSION['email'])) {
    header("Location: login.php");
    exit();
}

$userEmail = $_SESSION['email'];

// Fetch user details
$userQuery = $conn->prepare("SELECT id, name FROM users WHERE email = ?");
$userQuery->bind_param("s", $userEmail);
$userQuery->execute();
$userResult = $userQuery->get_result();
$userData = $userResult->fetch_assoc();
$userName = $userData ? $userData['name'] : "Unknown User";
$userId   = $userData ? $userData['id'] : 0;

// Fetch order history only for this user
$sql = "SELECT o.order_number, o.created_at, i.product_name, i.pages, i.price, i.total
        FROM order_items i
        JOIN orders o ON i.order_id = o.id
        WHERE o.user_id = ?
        ORDER BY o.created_at DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
?>

<div class="container mt-5">
  <h2>🧾 Order History</h2>
  <table class="table table-bordered">
    <thead class="table-dark">
      <tr>
        <th>#</th>
        <th>User Name</th>
        <th>Order No</th>
        <th>Product</th>
        <th>Pages</th>
        <th>Price</th>
        <th>Total</th>
        <th>Created At</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $sn = 1;
      while ($row = $result->fetch_assoc()) {
        echo "<tr>
          <td>{$sn}</td>
          <td>{$userName}</td>
          <td>{$row['order_number']}</td>
          <td>{$row['product_name']}</td>
          <td>{$row['pages']}</td>
          <td>₹{$row['price']}</td>
          <td>₹{$row['total']}</td>
          <td>{$row['created_at']}</td>
        </tr>";
        $sn++;
      }
      ?>
    </tbody>
  </table>
</div>
